package hu.afghangoat;

import hu.afghangoat.exceptions.InvalidDistanceException;
import hu.afghangoat.exceptions.InvalidGoalPositionException;
import hu.afghangoat.simulators.MouseEventSimulator;
import hu.afghangoat.widgets.FancyButton;
import hu.afghangoat.widgets.GuessMap;
import org.junit.jupiter.api.Test;

import java.awt.*;

import static org.junit.jupiter.api.Assertions.*;

//isPlacedMarker,setMarkerTo,getDistanceAccuracy,getGuessedDistance,simulateDrag,simulateClick,zoomAndPanFactor
public class WidgetsTest {

    @Test
    void guessMapTest2() throws InvalidGoalPositionException, InvalidDistanceException {
        GuessMap m1 = new GuessMap(1.0);
        assertFalse(m1.isPlacedMarker());

        m1.setGoalPos(3,3);

        assertDoesNotThrow(() -> {m1.setMarkerTo(3,3);});

        assertTrue(m1.isPlacedMarker());

        assertEquals(0.0,m1.getDistanceAccuracy(),0.01);

    }
    @Test
    void guessMapTest3() throws InvalidGoalPositionException, InvalidDistanceException {
        GuessMap m1 = new GuessMap(1.0);
        assertFalse(m1.isPlacedMarker());

        m1.setGoalPos(0,0);

        assertDoesNotThrow(() -> {m1.setMarkerTo(3,3);});

        assertTrue(m1.isPlacedMarker());

        assertEquals(1.7125,m1.getDistanceAccuracy(),0.01);

    }

    @Test
    void guessMapTest4() throws InvalidGoalPositionException, InvalidDistanceException {
        GuessMap m1 = new GuessMap(1.0);

        //No image map set and thus no width and height is present.

        assertEquals(m1.getPreferredSize().getHeight(),-1.0);
        assertEquals(m1.getPreferredSize().getWidth(),-1.0);

    }

    @Test
    void guessMapTest5() {
        GuessMap m1 = new GuessMap(1.0);
        assertFalse(m1.isPlacedMarker());

        m1.setGoalPos(0,0);

        assertDoesNotThrow(() -> {m1.setMarkerTo(3,3);});

        assertTrue(m1.isPlacedMarker());

        assertEquals(4.242,m1.getGuessedDistance(),0.01);

    }

    @Test
    void guessMapDragTest(){
        GuessMap m1 = new GuessMap(1.0);

        MouseEventSimulator sim1 = new MouseEventSimulator();

        sim1.simulateDrag(100,100,0,0,m1);

        sim1.simulateClick(100,100,m1);

        //Only movement, no place
        assertFalse(m1.isPlacedMarker());

    }

    @Test
    void guessMapPanFactorTest(){
        GuessMap m1 = new GuessMap(1.0);

        assertEquals(1.0,m1.zoomAndPanFactor(1.0,0.0),0.01);

        GuessMap m2 = new GuessMap(0.1);

        assertEquals(2.0,m2.zoomAndPanFactor(1.0,-1.0),0.01);

    }

    //Frame test

    @Test
    void fancyButtonTest(){
        FancyButton b1 = new FancyButton("Text1");

        //Should run, test for right inheritance settings and calling super.
        assertEquals(b1.getText(),"Text1");

        assertEquals(b1.getForeground(), Color.BLACK);

    }
}
