package hu.afghangoat;

import hu.afghangoat.helpers.FlatMapCoordinate;
import hu.afghangoat.helpers.FlatMapParser;
import hu.afghangoat.helpers.GPSCoordinate;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

//toFlatMappcoord
public class CoordinatesTest {

    private static ConfigParser cp;

    @BeforeAll
    static void init(){
        cp = new ConfigParser();
    }

    @Test
    void conversionTest(){
        GPSCoordinate c1 = new GPSCoordinate(47.46,11.000);

        FlatMapCoordinate result = c1.toFlatMapCoordinate();

        assertEquals(1602173.1707909005,result.getPosX());
        assertEquals(5951.475038333254,result.getPosY());
    }

    //Test will not work properly if a proper config directory is not present.
    @Test
    void flatMapParsingTest1(){

        assertDoesNotThrow(() -> {
            FlatMapParser f1 = new FlatMapParser();
        });

    }

    @Test
    void flatMapCoordinateConstructorTest(){
        FlatMapCoordinate c1 = new FlatMapCoordinate(2.0,3.0);

        assertEquals(2.0,c1.getPosX());
        assertEquals(3.0,c1.getPosY());
    }
}
