package hu.afghangoat;

import hu.afghangoat.blockchain.Block;
import hu.afghangoat.blockchain.BlockChainHelper;
import hu.afghangoat.blockchain.BlockComparator;
import hu.afghangoat.blockchain.Transaction;
import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

//compare,hashCode,verifyHash,clearEntries,addBlock,transactionFromString,clone,toHTMLSorted,saveToFile,loadFromFile
public class BlockChainTest {

    static Transaction t1;
    static Transaction t2;

    //Legalább 3 osztály összesen 10 metódusának tesztelése.

    @Test
    void testTransactions(){
        Transaction t1 = new Transaction("User1",200);
        Transaction t2 = new Transaction("User2",300);

        assertNotEquals(t1,t2);

        //Hash code test
        assertNotEquals(t1.hashCode(),t2.hashCode());
    }


    @Test
    void testBlocks(){
        Transaction t1 = new Transaction("User1",200);
        Transaction t2 = new Transaction("User2",300);

        Block b1 = new Block(0, new ArrayList<>(List.of(t1)).toArray(new Transaction[0]));
        Block b2 = new Block(b1.hashCode(), new ArrayList<>(List.of(t2)).toArray(new Transaction[0]));

        BlockComparator comp = new BlockComparator();
        assertTrue(comp.compare(b1,b2) < 0);
    }

    @Test
    void testToHTMLSorted(){
        BlockChainHelper bh = new BlockChainHelper(0);

        bh.addBlock("User1",200);
        bh.addBlock("User2",300);

        String out = bh.toHTMLSorted(2);

        assertEquals("<html><ul><li><b> #1</b>User2 - 300</li><li><b> #2</b>User1 - 200</li></ul></html>",out);
    }

    @Test
    void testSaveToFile(){
        BlockChainHelper bh = new BlockChainHelper(0);

        bh.addBlock("User1",200);
        bh.addBlock("User2",300);

        assertDoesNotThrow(() -> {
            bh.saveToFile("test1.txt");
        });
    }

    @Test
    void testLoadFromFile(){
        BlockChainHelper bh = new BlockChainHelper(0);

        //Should still be true, it will create an empty save file upon non-exsitence.
        assertTrue(bh.loadFromFile("testNOTEXIST.txt"));

    }



    @Test
    void testToHTMLSortedTop1(){
        BlockChainHelper bh = new BlockChainHelper(0);

        bh.addBlock("User1",200);
        bh.addBlock("User2",300);

        String out = bh.toHTMLSorted(1);

        assertEquals("<html><ul><li><b> #1</b>User2 - 300</li></ul></html>",out);
    }

    @Test
    void testBlockChainIntegrity(){

        BlockChainHelper bh = new BlockChainHelper(0);

        bh.addBlock("User1",200);
        bh.addBlock("User2",300);

        assertTrue(bh.verifyHash());

        bh.clearEntries();

        //Should be true too after clearing.
        assertTrue(bh.verifyHash());

        //Adding bad hashes
        bh.addBlock(new Transaction[]{new Transaction("Genesis",100)},0); //Hash is negligible here
        bh.addBlock(new Transaction[]{new Transaction("AAAAA",100)},-1); //Bad hash
        bh.addBlock(new Transaction[]{new Transaction("AAAAA",100)},-1); //Bad hash

        assertFalse(bh.verifyHash());
    }

    @Test
    void testFromString(){

        BlockChainHelper bh = new BlockChainHelper(0);

        Transaction t1 = bh.transactionFromString("Transaction{:User:,:100:}");

        assertEquals(t1.getSource(),"User");
        assertEquals(t1.getScore(),100);
    }

    @Test
    void blockCloneTest(){
        Block b1 = new Block(100, new Transaction[]{new Transaction("User",100)});

        Block b2 = b1.clone();

        assertEquals(b1.getPrevHash(),b2.getPrevHash());

        int transactionsAmount = b2.getTransactions().length;

        for(int i=0;i<transactionsAmount;i++){
            //There should be a b1 null check, but the test will catch it anyway.

            assertEquals(b1.getTransactions()[i].getScore(),b2.getTransactions()[i].getScore());
            assertEquals(b1.getTransactions()[i].getSource(),b2.getTransactions()[i].getSource());
        }

    }
}
