package hu.afghangoat.views;

import hu.afghangoat.ConfigParser;
import hu.afghangoat.exceptions.InvalidGoalPositionException;
import hu.afghangoat.helpers.ImageHelper;
import hu.afghangoat.LangEntry;
import hu.afghangoat.LangParser;
import hu.afghangoat.widgets.FancyButton;
import hu.afghangoat.widgets.GradientPanel;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

/**
 * @class MenuPanel
 * @brief The panel provides a main menu interface for the user where the user can select the subpanel for visiting.
 *
 */
public class MenuPanel extends GradientPanel implements ViewInterface, ActionListener {

    /**
     * @brief This label holds the title of the game.
     */
    private JLabel label = new JLabel("TITLE");

    /**
     * @brief When clicking this button, it redirects to the how to play panel.
     */
    private JButton howToPlayBtn;

    /**
     * @brief When clicking this button, it redirects to the game panel and starts a game.
     */
    private JButton startBtn;

    /**
     * @brief When clicking this button, it redirects to the settings panel.
     */
    private JButton settingsBtn;

    /**
     * @brief When clicking this button, it redirects to the credits panel.
     */
    private JButton creditsBtn;

    //private JButton scoreboardBtn;

    /**
     * @brief When clicking this button, it redirects to the scoreboard panel.
     */
    private JButton topPanelBtn;

    /**
     * @brief This method handles what should happen when the language is changed.
     */
    @Override
    public void langChanged(){
        label.setText(LangParser.getLang("TITLE"));
        howToPlayBtn.setText(LangParser.getLang("HOWTOPLAY"));
        settingsBtn.setText(LangParser.getLang("SETTINGS"));
        creditsBtn.setText(LangParser.getLang("CREDITS"));
        startBtn.setText(LangParser.getLang("START"));
        topPanelBtn.setText(LangParser.getLang("TOPBTN"));
    }

    /**
     * @brief This constructor sets up the layout of the panel and sets the event listeners. Also takes the parent window account.
     *
     * @param mainWindow The parent window of the panel.
     */
    public MenuPanel(MainWindow mainWindow) {
        super(new GridBagLayout());

        //setLayout();

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = GridBagConstraints.RELATIVE;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.fill = GridBagConstraints.NONE;
        gbc.insets = new Insets(10, 10, 10, 10); // spacing

        ImageIcon icon = new ImageIcon(ConfigParser.getConfigPath() + "icon.png");
        JLabel label2 = new JLabel(icon);

        GridBagConstraints image_gbc = new GridBagConstraints();
        image_gbc.gridx = 0;
        image_gbc.gridy = GridBagConstraints.RELATIVE;
        image_gbc.anchor = GridBagConstraints.CENTER;
        image_gbc.fill = GridBagConstraints.NONE;
        image_gbc.insets = new Insets(40, 10, 25, 10); // spacing

        add(label2,image_gbc);

        GridBagConstraints label_gbc = new GridBagConstraints();
        label_gbc.gridx = 0;
        label_gbc.gridy = GridBagConstraints.RELATIVE;
        label_gbc.anchor = GridBagConstraints.CENTER;
        label_gbc.fill = GridBagConstraints.NONE;
        label_gbc.insets = new Insets(0, 10, 25, 10); // spacing

        label.setFont(new Font("Segoe UI", Font.BOLD, 30));
        add(label,label_gbc);

        startBtn = new FancyButton("START");
        startBtn.addActionListener(e -> {
            try {
                mainWindow.requestStartRound();
            } catch (InvalidGoalPositionException ex) {
                System.out.println("Failed to start the round! Invalid goal position was set!");
            }
            mainWindow.showView("GAME");
        });
        add(startBtn, gbc);

        howToPlayBtn = new FancyButton("HOWTOPLAY");
        howToPlayBtn.addActionListener(e -> mainWindow.showView("HOWTO"));
        add(howToPlayBtn, gbc);

        settingsBtn = new FancyButton("SETTINGS");
        settingsBtn.addActionListener(e -> mainWindow.showView("SETTINGS"));
        add(settingsBtn, gbc);

        creditsBtn = new FancyButton("CREDITS");
        creditsBtn.addActionListener(e -> mainWindow.showView("CREDITS"));
        add(creditsBtn, gbc);

        topPanelBtn = new FancyButton("TOPBTN");
        topPanelBtn.addActionListener(e -> {
            mainWindow.showView("TOP_PANEL");
            mainWindow.onTopListMessageReceived();
        });
        add(topPanelBtn, gbc);

        JPanel rowPanel = new JPanel();
        rowPanel.setOpaque(true);
        rowPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 5));

        List<LangEntry> langs= mainWindow.cp.getLanguages();
        if(langs!=null){
            for(int i=0;i<langs.size();i++){
                System.out.println(langs.get(i).getName());
                ImageIcon tempLangIcon = ImageHelper.resizedImage(ConfigParser.getLangsPath() + langs.get(i).getName()+".png",(int)(192.0*mainWindow.cp.getLangIconScale()),(int)(128.0*mainWindow.cp.getLangIconScale()));
                JButton lang_btn=new FancyButton(tempLangIcon);
                lang_btn.setToolTipText(langs.get(i).getTooltip());
                rowPanel.add(lang_btn);
                String langName = langs.get(i).getName();
                lang_btn.addActionListener( e->{
                    //System.out.println("Loaded: "+langName);
                    mainWindow.cp.setCurrentLang(langName);
                    mainWindow.setRF(new LangParser(ConfigParser.getLangsPath()+langName+".lang"));
                    mainWindow.changeLangForAll();
                });
            }
        }


        add(rowPanel, gbc);
    }

    /**
     * @brief Empty action listener, needs to be implemented.
     *
     * @param e The event of the action.
     * @deprecated Moved logic to the constructor.
     */
    @Override
    @Deprecated
    public void actionPerformed(ActionEvent e) {

    }
}