package hu.afghangoat.simulators;

import hu.afghangoat.widgets.GuessMap;

import java.awt.event.MouseEvent;

/**
 * @class MouseEventSimulator
 * @brief A utility class which helps in simulation user mouse clicks.
 *
 * Used in testing and in production too.
 *
 */
public class MouseEventSimulator {

    /**
     * @brief Simulates a mouse drag from X1,Y1 to X2,Y2 on p GuessMap.
     *
     * @param fromX The X1 coordinate component.
     * @param fromY The Y1 coordinate component.
     * @param toX The X2 coordinate component.
     * @param toY The Y2 coordinate component.
     * @param p The reference to the GuessMap.
     */
    public void simulateDrag(int fromX, int fromY, int toX, int toY, GuessMap p){
        MouseEvent press = new MouseEvent(p, MouseEvent.MOUSE_PRESSED,
                System.currentTimeMillis(), 0, fromX, fromY, 1, false, MouseEvent.BUTTON1);
        MouseEvent drag = new MouseEvent(p, MouseEvent.MOUSE_DRAGGED,
                System.currentTimeMillis(), 0, toX, toY, 0, false, MouseEvent.BUTTON1);
        p.dispatchEvent(drag);
        MouseEvent release = new MouseEvent(p, MouseEvent.MOUSE_RELEASED,
                System.currentTimeMillis(), 0, toX, toY, 0, false, MouseEvent.BUTTON1);
        p.dispatchEvent(release);
        p.dispatchEvent(press);
    }

    /**
     * @brief Simulates a mouse click on an X,Y coordinate pair on p GuessMap.
     *
     * @param X The X coordinate component of the mouse click position.
     * @param Y The Y coordinate component of the mouse click position.
     * @param p The reference to the GuessMap.
     */
    public void simulateClick(int X, int Y, GuessMap p){
        MouseEvent press = new MouseEvent(p, MouseEvent.MOUSE_PRESSED, System.currentTimeMillis(), 0, X, Y, 1, false, MouseEvent.BUTTON1);
        MouseEvent release = new MouseEvent(p, MouseEvent.MOUSE_RELEASED, System.currentTimeMillis(), 0, X, Y, 0, false, MouseEvent.BUTTON1);
        p.dispatchEvent(release);
        p.dispatchEvent(press);
    }
}
