package hu.afghangoat.helpers;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

/**
 * @class ImageHelper
 * @brief A utility class which helps in the resizing of Swing specific images.
 *
 */
public class ImageHelper {

    /**
     * @brief Takes in an image path and returns that image loaded with a specified size.
     *
     * @param path The location of the image.
     * @param width The width of the resized image.
     * @param height The height of the resized image.
     *
     * @return An instance of the resized image in ImageIcon format.
     */
    public static ImageIcon resizedImage(String path, int width, int height){
        ImageIcon originalIcon = new ImageIcon(path);
        Image scaledImage = originalIcon.getImage().getScaledInstance(width, height, Image.SCALE_SMOOTH);
        ImageIcon scaledIcon = new ImageIcon(scaledImage);
        return scaledIcon;
    }
}
