package hu.afghangoat.helpers;

/**
 * @class FlatMapCoordinate
 * @brief A data structure which holds the coordinate based on its location on the 2d flattened map.
 *
 * (Not geo coordinates, flat X,Y coordinate pairs.)
 *
 */
public class FlatMapCoordinate {

    /**
     * @brief The X component of the coordinate.
     *
     * Can be fractional value.
     */
    private double posX;

    /**
     * @brief The Y component of the coordinate.
     *
     * Can be fractional value.
     */
    private double posY;

    /**
     * @brief A getter for the Y component of the position.
     *
     * @return The Y component of the position of the coordinate.
     */
    public double getPosY() {
        return posY;
    }

    /**
     * @brief A getter for the X component of the position.
     *
     * @return The X component of the position of the coordinate.
     */
    public double getPosX() {
        return posX;
    }

    /**
     * @brief A constructor which takes in 2 double positions and constructs a coordinate from them.
     *
     * @param _posX The X component of the to-be-constructed position.
     * @param _posY The Y component of the to-be-constructed position.
     */
    public FlatMapCoordinate(double _posX, double _posY) {
        this.posX = _posX;
        this.posY = _posY;
    }
}
