package hu.afghangoat.blockchain;

import java.util.Comparator;

/**
 * @class BlockComparator
 * @brief A helper comparator which can compare blockchain blocks based on their leading transaction scores.
 *
 */
public class BlockComparator implements Comparator<Block> {
    @Override
    /**
     * @brief Implements the comparator comparable for the Block comparison.
     *
     * It works by getting the first score entry from the block's transactions.
     *
     * @param b1 The first block.
     * @param b1 The second block.
     *
     * @return >0 if the block1 is larger, 0 if they are equal and else 0<
     */
    public int compare(Block b1, Block b2) {
        return Integer.compare(b1.getTransactions()[0].getScore(),b2.getTransactions()[0].getScore());
    }
}
