package hu.afghangoat;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @class LangParser
 * @brief The component responsible for loading and parsing the given languages from an XML format.
 *
 * Uses the ConfigParser.
 *
 */
public class LangParser {
    /**
     * @brief This variable contains the language entries for each label, button or text literal.
     *
     * Format: k = Literal, v = Language entry
     */
    private static Map<String,String> map = new HashMap<>();

    /**
     * @brief The constructor of a LangParser. It sets the language entries map from a file.
     *
     * @param path The location of the language file.
     * Language files are XML files with .lang extensions.
     */
    public LangParser(String path) {

        File file = new File(path);
        if (file.exists()) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build(file);

                Element root = document.getRootElement(); // <config>
                List<Element> entries = root.getChildren("entry");

                for (Element entry : entries) {
                    String key = entry.getAttributeValue("key");
                    String value = entry.getText();
                    map.put(key, value);
                }

            } catch (Exception e) {
                System.err.println("Error reading the file: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("File does not exist: " + path);
        }
    }

    /**
     * @brief Returns the language entry corresponding to the literal from the map.
     *
     * @param what The literal we search.
     *
     * @return The language entry.
     */
    public static String getLang(String what){
        String val=map.get(what);
        if(val == null){
            return "INVALID_LANG_ENTRY";
        } else {
            return val;
        }

    }
}
