package hu.afghangoat;

/**
 * @class LangEntry
 * @brief A data structure which represents a language with its name and a corresponding ID.
 */
public class LangEntry {

    /**
     * @brief The name of the language.
     */
    private String name="";

    /**
     * @brief The ID of the language.
     */
    private String tooltip="";

    /**
     * @brief A constructor which initializes the name and ID of the language.
     *
     * @param aName The name of the language.
     *
     * @param aTooltip The ID of the language.
     */
    LangEntry(String aName, String aTooltip){
        name=aName;
        tooltip=aTooltip;
    }

    /**
     * @brief A getter for the name.
     *
     * @return The name of the language.
     */
    public String getName() {
        return name;
    }

    /**
     * @brief A getter for the ID.
     *
     * @return The ID of the language.
     */
    public String getTooltip() {
        return tooltip;
    }
}
