
plugins {
    id("java")
}

group = "hu.afghangoat"
version = "1.0-SNAPSHOT"

repositories {
    mavenCentral()
}

dependencies {
    testImplementation(platform("org.junit:junit-bom:5.10.0"))
    testImplementation("org.junit.jupiter:junit-jupiter")
    implementation("com.drewnoakes:metadata-extractor:2.18.0")
    implementation("org.jdom:jdom2:2.0.6.1")
}

tasks.register<Jar>("fatJar") {
    archiveClassifier.set("all")

    manifest {
        attributes["Main-Class"] = "hu.afghangoat.Main"
    }

    from(sourceSets.main.get().output)

    // Include all runtime dependencies
    dependsOn(configurations.runtimeClasspath)
    from({
        configurations.runtimeClasspath.get()
            .filter { it.name.endsWith("jar") }
            .map { zipTree(it) }
    })
}


tasks.jar {
    archiveClassifier.set("all")

    manifest {
        attributes["Main-Class"] = "hu.afghangoat.Main"
        attributes["Implementation-Version"] = "1.0.1"
    }

    from(sourceSets.main.get().output)

    destinationDirectory.set(file("$projectDir"))

    // Include all runtime dependencies
    dependsOn(configurations.runtimeClasspath)
    from({
        configurations.runtimeClasspath.get()
            .filter { it.name.endsWith("jar") }
            .map { zipTree(it) }
    })
}

tasks.test {
    useJUnitPlatform()
}