/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.widgets;

import hu.afghangoat.ConfigParser;
import hu.afghangoat.exceptions.InvalidDistanceException;
import hu.afghangoat.exceptions.InvalidGoalPositionException;
import hu.afghangoat.helpers.FlatMapCoordinate;
import hu.afghangoat.helpers.GPSCoordinate;
import hu.afghangoat.helpers.MathHelpers;
import hu.afghangoat.simulators.MouseEventSimulator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class GuessMap
extends JLabel
implements MouseWheelListener,
MouseListener,
MouseMotionListener {
    public static final double minZoomFactor = 0.5;
    public static final double maxZoomFactor = 1.0;
    private ImageIcon icon;
    private Image image;
    private ImageIcon originalIcon;
    private double scale = 1.0;
    private double zoomFactor = 1.0;
    private double prevZoomFactor = 1.0;
    private boolean zoomer;
    private boolean dragger;
    private boolean released;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private int xDiff;
    private int yDiff;
    private Point startPoint;
    private double selfImgWidth;
    private double selfImgHeight;
    boolean placedMarker = false;
    private ImageIcon markerIcon;
    private Image markerImage;
    private double markerImgWidth;
    private double markerImgHeight;
    private double markerPosX = -1.0;
    private double markerPosY = -1.0;
    private double distanceAccuracy = -1.0;
    private boolean guessed = false;
    private double goalPosX = -1.0;
    private double goalPosY = -1.0;

    public boolean isPlacedMarker() {
        return this.placedMarker;
    }

    public double getDistanceAccuracy() throws InvalidDistanceException {
        if (this.distanceAccuracy == -1.0) {
            throw new InvalidDistanceException("For some reason, no distanceAccuracy set.");
        }
        this.guessed = true;
        this.repaint();
        return this.distanceAccuracy * GPSCoordinate.pixelsPerMeter;
    }

    public double getGuessedDistance() {
        double dx = this.markerPosX - this.goalPosX;
        double dy = this.markerPosY - this.goalPosY;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public void setGoalPos(double gPX, double gPY) {
        this.guessed = false;
        this.distanceAccuracy = -1.0;
        this.placedMarker = false;
        this.markerPosX = -1.0;
        this.markerPosY = -1.0;
        this.goalPosX = gPX;
        this.goalPosY = gPY;
    }

    public void setGoalPos(FlatMapCoordinate coords) {
        this.setGoalPos(coords.getPosX(), coords.getPosY());
    }

    public void setMarkerTo(double nX, double nY) throws InvalidGoalPositionException {
        if (this.goalPosX == -1.0 || this.goalPosY == -1.0) {
            throw new InvalidGoalPositionException("No goal was set or its position is invalid");
        }
        this.placedMarker = true;
        System.out.println("Marker placed");
        this.markerPosX = (int)nX;
        this.markerPosY = (int)nY;
        this.distanceAccuracy = this.getGuessedDistance();
    }

    public GuessMap(double _scale) {
        this.scale = _scale;
        this.originalIcon = new ImageIcon(ConfigParser.getConfigPath() + "uni_map.png");
        this.selfImgWidth = this.originalIcon.getIconWidth();
        this.selfImgHeight = this.originalIcon.getIconHeight();
        this.image = this.originalIcon.getImage();
        this.icon = new ImageIcon(this.image);
        this.markerIcon = new ImageIcon(ConfigParser.getConfigPath() + "assets/location.png");
        this.markerImgWidth = this.markerIcon.getIconWidth();
        this.markerImgHeight = this.markerIcon.getIconHeight();
        this.markerImage = this.markerIcon.getImage();
        this.setOpaque(true);
        this.addListeners();
    }

    private void addListeners() {
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)(this.selfImgWidth * this.scale), (int)(this.selfImgHeight * this.scale));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform at = this.getAffineTransform();
        g2.setTransform(at);
        g2.drawImage(this.image, 0, 0, this);
        if (this.markerPosX != -1.0 && this.markerPosY != -1.0) {
            g2.drawImage(this.markerImage, (int)(this.markerPosX - this.markerImgWidth / 2.0), (int)(this.markerPosY - this.markerImgHeight), this);
        }
        if (this.markerPosX != -1.0 && this.markerPosY != -1.0) {
            g2.drawImage(this.markerImage, (int)(this.markerPosX - this.markerImgWidth / 2.0), (int)(this.markerPosY - this.markerImgHeight), this);
            if (this.guessed) {
                int x = 50;
                int y = 50;
                int z = 200;
                int w = 200;
                g2.setColor(Color.DARK_GRAY);
                g2.setStroke(new BasicStroke(5.0f));
                g2.drawLine((int)this.markerPosX, (int)this.markerPosY, (int)this.goalPosX, (int)this.goalPosY);
            }
        }
    }

    private AffineTransform getAffineTransform() {
        double imageWidth = this.selfImgWidth * this.zoomFactor;
        double imageHeight = this.selfImgHeight * this.zoomFactor;
        double minXOffset = Math.min(0.0, (double)this.getWidth() - imageWidth);
        double minYOffset = Math.min(0.0, (double)this.getHeight() - imageHeight);
        double clampedX = Math.max(minXOffset, Math.min(0.0, this.xOffset));
        double clampedY = Math.max(minYOffset, Math.min(0.0, this.yOffset));
        AffineTransform at = new AffineTransform();
        at.translate(clampedX, clampedY);
        at.scale(this.zoomFactor, this.zoomFactor);
        return at;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.zoomer = true;
        if (e.getWheelRotation() < 0) {
            this.zoomFactor *= 1.1;
            if (this.zoomFactor > 1.0) {
                this.zoomFactor = 1.0;
            }
            this.repaint();
        }
        if (e.getWheelRotation() > 0) {
            this.zoomFactor /= 1.1;
            if (this.zoomFactor < 0.5) {
                this.zoomFactor = 0.5;
            }
            this.xOffset /= 1.1;
            this.yOffset /= 1.1;
            this.repaint();
        }
        this.repaint();
        MouseEventSimulator view_fixer = new MouseEventSimulator();
        view_fixer.simulateDrag(50, 50, 49, 49, this);
    }

    public void zoomIn() {
        this.repaintWithParent();
    }

    public void repaintWithParent() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint();
        }
        this.repaint();
    }

    public void zoomOut() {
        this.repaintWithParent();
    }

    public double zoomAndPanFactor(double mousePos, double offset) {
        return (mousePos - offset) / this.zoomFactor;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.guessed) {
            return;
        }
        int mouseX = e.getX();
        int mouseY = e.getY();
        double imageX = ((double)mouseX - this.xOffset) / this.zoomFactor;
        double imageY = ((double)mouseY - this.yOffset) / this.zoomFactor;
        imageX = MathHelpers.clampd(imageX, 0.0, this.image.getWidth(null) - 1);
        imageY = MathHelpers.clampd(imageY, 0.0, this.image.getHeight(null) - 1);
        try {
            this.setMarkerTo(imageX, imageY);
        }
        catch (InvalidGoalPositionException ex) {
            System.out.println("Failed to set marker, no valid goal pos defined!");
        }
        e.consume();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.released = false;
        this.startPoint = e.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        int dx = e.getX() - this.startPoint.x;
        int dy = e.getY() - this.startPoint.y;
        this.xOffset += (double)dx;
        this.yOffset += (double)dy;
        double imageWidth = this.selfImgWidth * this.zoomFactor;
        double imageHeight = this.selfImgHeight * this.zoomFactor;
        double minXOffset = Math.min(0.0, (double)this.getWidth() - imageWidth);
        double minYOffset = Math.min(0.0, (double)this.getHeight() - imageHeight);
        this.xOffset = Math.max(minXOffset, Math.min(0.0, this.xOffset));
        this.yOffset = Math.max(minYOffset, Math.min(0.0, this.yOffset));
        this.startPoint = e.getPoint();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.released = true;
        this.startPoint = null;
        this.dragger = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

