/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.views;

import hu.afghangoat.ConfigParser;
import hu.afghangoat.LangParser;
import hu.afghangoat.views.MainWindow;
import hu.afghangoat.views.ViewInterface;
import hu.afghangoat.widgets.BackButton;
import hu.afghangoat.widgets.GradientPanel;
import hu.afghangoat.widgets.StyleWidget;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SettingsPanel
extends GradientPanel
implements ViewInterface,
ActionListener {
    private JLabel label = new JLabel("SETINGS_DESCRIPTION");
    private JLabel bg_label = new JLabel("SETINGS_DESCRIPTION_BG");
    private BackButton backBtn;
    private ArrayList<StyleWidget> styleOptions = new ArrayList();

    @Override
    public void langChanged() {
        this.label.setText(LangParser.getLang("SETINGS_DESCRIPTION"));
        this.bg_label.setText(LangParser.getLang("SETINGS_DESCRIPTION_BG"));
        this.backBtn.setText(LangParser.getLang("BACK"));
    }

    private StyleWidget getWidgetByName(String name) {
        for (int i = 0; i < this.styleOptions.size(); ++i) {
            if (!this.styleOptions.get(i).getName().equals(name)) continue;
            return this.styleOptions.get(i);
        }
        return null;
    }

    private void makeButtonGroup(MainWindow mainWindow) {
        ButtonGroup group = new ButtonGroup();
        JPanel buttonPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 25, 10);
        ActionListener listener = e -> {
            JRadioButton source = (JRadioButton)e.getSource();
            StyleWidget curWidget = this.getWidgetByName(source.getText());
            if (curWidget == null) {
                throw new RuntimeException("NULL style was set. This is unexpected.");
            }
            GradientPanel.setGradientColors(curWidget.getBgGradientColor1(), curWidget.getBgGradientColor2());
            mainWindow.setColorForAll(curWidget.getFontColor());
            this.repaint();
        };
        for (int i = 0; i < this.styleOptions.size(); ++i) {
            JRadioButton option = new JRadioButton(this.styleOptions.get(i).getName());
            if (i == 0) {
                option.setSelected(true);
            }
            group.add(option);
            option.addActionListener(listener);
            buttonPanel.add(option);
        }
        this.add((Component)buttonPanel, gbc);
    }

    public SettingsPanel(MainWindow mainWindow) {
        super(new GridBagLayout());
        this.styleOptions = mainWindow.cp.getThemes(ConfigParser.getConfigPath() + "styles.xml");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 25, 10);
        this.backBtn = new BackButton(mainWindow, "BACK");
        this.label.setFont(new Font("Segoe UI", 1, 30));
        this.add((Component)this.label, gbc);
        this.add((Component)this.bg_label, gbc);
        this.makeButtonGroup(mainWindow);
        this.add((Component)this.backBtn, gbc);
    }

    @Override
    @Deprecated
    public void actionPerformed(ActionEvent e) {
    }
}

