/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.views;

import hu.afghangoat.ConfigParser;
import hu.afghangoat.LangParser;
import hu.afghangoat.blockchain.BlockChainHelper;
import hu.afghangoat.exceptions.InvalidGoalPositionException;
import hu.afghangoat.views.CreditsPanel;
import hu.afghangoat.views.EndGamePanel;
import hu.afghangoat.views.GamePanel;
import hu.afghangoat.views.HowToPanel;
import hu.afghangoat.views.MenuPanel;
import hu.afghangoat.views.SettingsPanel;
import hu.afghangoat.views.TopListPanel;
import hu.afghangoat.views.ViewInterface;
import hu.afghangoat.widgets.GradientPanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MainWindow
extends JFrame {
    private CardLayout cardLayout;
    private JPanel mainPanel;
    public static final Dimension DIVINE_SIZE = new Dimension(640, 480);
    public ConfigParser cp;
    private LangParser rf;
    private EndGamePanel ePanel;
    private TopListPanel topPanel;
    private GamePanel gPanel;
    private SettingsPanel settingsPanel;
    public static int TOP_LIST_HASH = 37181;
    private BlockChainHelper topListHelper = new BlockChainHelper(TOP_LIST_HASH);

    public void setRF(LangParser lp) {
        this.rf = lp;
    }

    public void addTopListEntry(String name, int score) {
        this.topListHelper.addBlock(name, score);
        this.topListHelper.saveToFile(ConfigParser.getConfigPath() + "top_list.PRIVATE");
    }

    public void onTopListMessageReceived() {
        if (!this.topListHelper.verifyHash()) {
            this.topPanel.setTopListEntriesLabel(LangParser.getLang("INTEGRITY_FAILED"));
            System.out.println("INTEGRITY_FAILED");
        } else {
            String entries = this.topListHelper.toHTMLSorted(10);
            this.topPanel.setTopListEntriesLabel(entries);
        }
    }

    public void requestStartRound() throws InvalidGoalPositionException {
        this.gPanel.startRound();
    }

    public MainWindow() {
        this.cp = new ConfigParser();
        this.rf = new LangParser(ConfigParser.getLangsPath() + this.cp.getCurrentLang() + ".lang");
        this.topListHelper.loadFromFile(ConfigParser.getConfigPath() + "top_list.PRIVATE");
        this.setTitle(ConfigParser.getTitle());
        this.setMinimumSize(DIVINE_SIZE);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.cardLayout = new CardLayout();
        this.mainPanel = new JPanel(this.cardLayout);
        this.mainPanel.add((Component)new MenuPanel(this), "MENU");
        this.mainPanel.add((Component)new HowToPanel(this), "HOWTO");
        this.mainPanel.add((Component)new CreditsPanel(this), "CREDITS");
        this.settingsPanel = new SettingsPanel(this);
        this.mainPanel.add((Component)this.settingsPanel, "SETTINGS");
        this.gPanel = new GamePanel(this);
        this.mainPanel.add((Component)this.gPanel, "GAME");
        this.ePanel = new EndGamePanel(this);
        this.mainPanel.add((Component)this.ePanel, "ENDGAME");
        this.topPanel = new TopListPanel(this);
        this.mainPanel.add((Component)this.topPanel, "TOP_PANEL");
        this.changeLangForAll();
        this.add(this.mainPanel);
        this.pack();
    }

    public void showScore(int score) {
        if (this.ePanel != null) {
            this.ePanel.showScore(score);
        }
    }

    public void clearFrame() {
        this.getContentPane().removeAll();
        this.revalidate();
        this.repaint();
    }

    public void showView(String name) {
        this.cardLayout.show(this.mainPanel, name);
    }

    public void changeLangForAll() {
        for (Component comp : this.mainPanel.getComponents()) {
            if (!(comp instanceof ViewInterface)) continue;
            ((ViewInterface)((Object)comp)).langChanged();
        }
    }

    public void setColorForAll(Color newColor) {
        for (Component comp : this.mainPanel.getComponents()) {
            if (!(comp instanceof GradientPanel)) continue;
            ((GradientPanel)comp).setTextColor(newColor);
        }
    }
}

