/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.views;

import hu.afghangoat.LangParser;
import hu.afghangoat.views.MainWindow;
import hu.afghangoat.views.ViewInterface;
import hu.afghangoat.widgets.BackButton;
import hu.afghangoat.widgets.FancyButton;
import hu.afghangoat.widgets.GradientPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EndGamePanel
extends GradientPanel
implements ViewInterface,
ActionListener {
    public static final int MAX_NAME_LENGTH = 20;
    private JLabel label = new JLabel("END_GAME_TITLE");
    private BackButton backBtn;
    private JButton submitButton;
    private JTextArea nameArea = new JTextArea("EDIT_NAME");
    private int finalScore = 0;

    @Override
    public void langChanged() {
        this.label.setText(LangParser.getLang("END_GAME_TITLE"));
        this.backBtn.setText(LangParser.getLang("BACK"));
        this.submitButton.setText(LangParser.getLang("SUBMIT"));
        this.nameArea.setText(LangParser.getLang("EDIT_NAME"));
    }

    public void showScore(int score) {
        this.finalScore = score;
        this.langChanged();
        this.label.setText((LangParser.getLang("END_GAME_TITLE") + ": ").replace("$", Integer.toString(this.finalScore)));
        this.label.revalidate();
        this.label.repaint();
    }

    public EndGamePanel(MainWindow mainWindow) {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 25, 10);
        this.backBtn = new BackButton(mainWindow, "BACK");
        this.label.setFont(new Font("Segoe UI", 1, 30));
        this.add((Component)this.label, gbc);
        this.nameArea.setMargin(new Insets(10, 10, 10, 10));
        this.nameArea.setMinimumSize(new Dimension(200, 28));
        this.nameArea.getDocument().addDocumentListener(new DocumentListener(){

            private void check() {
                if (EndGamePanel.this.nameArea.getText().length() > 20) {
                    SwingUtilities.invokeLater(() -> EndGamePanel.this.nameArea.setText(EndGamePanel.this.nameArea.getText().substring(0, 20)));
                }
                if (EndGamePanel.this.nameArea.getText().contains(":")) {
                    SwingUtilities.invokeLater(() -> EndGamePanel.this.nameArea.setText(EndGamePanel.this.nameArea.getText().replaceAll(":", "")));
                }
                if (EndGamePanel.this.nameArea.getText().contains("|")) {
                    SwingUtilities.invokeLater(() -> EndGamePanel.this.nameArea.setText(EndGamePanel.this.nameArea.getText().replaceAll("\\|", "")));
                }
                if (EndGamePanel.this.nameArea.getText().contains("'")) {
                    SwingUtilities.invokeLater(() -> EndGamePanel.this.nameArea.setText(EndGamePanel.this.nameArea.getText().replaceAll("'", "")));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.add((Component)this.nameArea, gbc);
        this.submitButton = new FancyButton("SUBMIT");
        this.add((Component)this.submitButton, gbc);
        this.add((Component)this.backBtn, gbc);
        this.submitButton.addActionListener(e -> {
            String newName = this.nameArea.getText();
            mainWindow.addTopListEntry(newName, this.finalScore);
            mainWindow.showView("MENU");
        });
    }

    @Override
    @Deprecated
    public void actionPerformed(ActionEvent e) {
    }
}

