/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.helpers;

import hu.afghangoat.helpers.GPSCoordinate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GPSReader {
    public static final int GPS_INFO_TAG = 34853;
    public static final int APP1_MARKER = 225;
    public static final int MARKER_START_SEGMENT = 255;
    public static final int SOI_START_BYTE1 = 255;
    public static final int SOI_START_BYTE2 = 216;

    public GPSCoordinate extractGps(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            if (fis.read() != 255 || fis.read() != 216) {
                throw new IOException("Not a JPEG file");
            }
            while (true) {
                int marker1 = fis.read();
                int marker2 = fis.read();
                if (marker1 != 255) {
                    break;
                }
                int marker = marker2;
                int lenHi = fis.read();
                int lenLo = fis.read();
                int length = lenHi << 8 | lenLo;
                if (this.isApp1(marker)) {
                    byte[] data = new byte[length - 2];
                    fis.read(data);
                    GPSCoordinate gPSCoordinate = this.parseExifForGps(data);
                    return gPSCoordinate;
                }
                long l = fis.skip(length - 2);
            }
        }
        return null;
    }

    private boolean isApp1(int marker) {
        return marker == 225;
    }

    private GPSCoordinate parseExifForGps(byte[] data) throws IOException {
        String header = new String(data, 0, 4, "ASCII");
        if (!header.equals("Exif")) {
            return null;
        }
        int tiffStart = 6;
        boolean gotByteOrder = data[tiffStart] == 73 && data[tiffStart + 1] == 73;
        ByteOrder bo = gotByteOrder ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(bo);
        buf.position(tiffStart + 4);
        int ifd0Offset = buf.getInt();
        int gpsOffset = this.findTagOffset(data, tiffStart + ifd0Offset, 34853, bo, tiffStart);
        if (gpsOffset == -1) {
            return null;
        }
        String latRef = this.readAsciiTag(data, gpsOffset, 1, bo, tiffStart);
        double lat = this.readRationalTag(data, gpsOffset, 2, bo, tiffStart);
        String lonRef = this.readAsciiTag(data, gpsOffset, 3, bo, tiffStart);
        double lon = this.readRationalTag(data, gpsOffset, 4, bo, tiffStart);
        if (latRef != null && latRef.equals("S")) {
            lat = -lat;
        }
        if (lonRef != null && lonRef.equals("W")) {
            lon = -lon;
        }
        return new GPSCoordinate(lat, lon);
    }

    private int findTagOffset(byte[] data, int ifdOffset, int wantedTag, ByteOrder bo, int tiffStart) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(bo);
        buf.position(ifdOffset);
        int numEntries = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numEntries; ++i) {
            int tag = buf.getShort() & 0xFFFF;
            int type = buf.getShort() & 0xFFFF;
            int count = buf.getInt();
            int valueOffset = buf.getInt();
            if (tag != wantedTag) continue;
            return tiffStart + valueOffset;
        }
        return -1;
    }

    private String readAsciiTag(byte[] data, int ifdOffset, int wantedTag, ByteOrder bo, int tiffStart) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(bo);
        buf.position(ifdOffset);
        int numEntries = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numEntries; ++i) {
            int tag = buf.getShort() & 0xFFFF;
            int type = buf.getShort() & 0xFFFF;
            int count = buf.getInt();
            int valueOffset = buf.getInt();
            if (tag != wantedTag) continue;
            int realOffset = count <= 4 ? buf.position() - 4 : tiffStart + valueOffset;
            return new String(data, realOffset, count - 1);
        }
        return null;
    }

    private double readRationalTag(byte[] data, int ifdOffset, int wantedTag, ByteOrder bo, int tiffStart) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(bo);
        buf.position(ifdOffset);
        int numEntries = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numEntries; ++i) {
            int tag = buf.getShort() & 0xFFFF;
            int type = buf.getShort() & 0xFFFF;
            int count = buf.getInt();
            int valueOffset = buf.getInt();
            if (tag != wantedTag) continue;
            int realOffset = tiffStart + valueOffset;
            double[] vals = new double[count];
            for (int j = 0; j < count; ++j) {
                int num = this.toInt(data, realOffset + j * 8, bo);
                int den = this.toInt(data, realOffset + j * 8 + 4, bo);
                vals[j] = den == 0 ? 0.0 : (double)num / (double)den;
            }
            return vals[0] + vals[1] / 60.0 + vals[2] / 3600.0;
        }
        return 0.0;
    }

    private int toInt(byte[] data, int offset, ByteOrder bo) {
        if (bo == ByteOrder.LITTLE_ENDIAN) {
            return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
        }
        if (bo == ByteOrder.BIG_ENDIAN) {
            return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
        }
        System.out.println("Invalid byteorder, skipping GPSReader.toInt() call!");
        return -1;
    }
}

