/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.helpers;

import hu.afghangoat.helpers.FlatMapCoordinate;

public class GPSCoordinate {
    double GPSLatitude = 0.0;
    double GPSLongitude = 0.0;
    public static final double BASE_LATITUDE = 47.473622222222225;
    public static final double BASE_LONGITUDE = 19.059227777777778;
    public static final double FLATMAP_OFFSET_X = 2348.7726148877664;
    public static final double FLATMAP_OFFSET_Y = 3247.3495229108244;
    public static final double EARTH_TO_PIXEL_PARAMETER = 156543.03392;
    public static final double CONVERSION_SCALE = 491794.44533372973;
    public static final boolean IS_ON_NORTHERN_HEMISPHERE = true;
    public static final int ZOOM = 18;
    public static final double rotationModifier = GPSCoordinate.decideRotationModifier();
    public static double pixelsPerMeter = GPSCoordinate.getPixelsPerMeter(18, 47.473622222222225);

    public static double decideRotationModifier() {
        double r = 1.0;
        r = -1.0;
        return r;
    }

    public static double getPixelsPerMeter(int zoom, double baseLat) {
        return 156543.03392 * Math.cos(Math.toRadians(baseLat)) / Math.pow(2.0, zoom);
    }

    public double getGPSLatitude() {
        return this.GPSLatitude;
    }

    public double getGPSLongitude() {
        return this.GPSLongitude;
    }

    public GPSCoordinate(double lat, double lon) {
        this.GPSLatitude = lat;
        this.GPSLongitude = lon;
    }

    public FlatMapCoordinate toFlatMapCoordinate() {
        return new FlatMapCoordinate(2348.7726148877664 - (19.059227777777778 - this.GPSLongitude) * 491794.44533372973 * pixelsPerMeter * rotationModifier, 3247.3495229108244 - (47.473622222222225 - this.GPSLatitude) * 491794.44533372973 * pixelsPerMeter * rotationModifier);
    }

    public static GPSCoordinate fromFlatMapCoordinate(FlatMapCoordinate coord) {
        return new GPSCoordinate((coord.getPosY() - 3247.3495229108244) / (491794.44533372973 * pixelsPerMeter * rotationModifier) + 47.473622222222225, (coord.getPosX() - 2348.7726148877664) / (491794.44533372973 * pixelsPerMeter * rotationModifier) + 19.059227777777778);
    }
}

