/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.helpers;

import hu.afghangoat.ConfigParser;
import hu.afghangoat.helpers.FlatMapCoordinate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderXSDFactory;

public class FlatMapParser {
    public static final String OFFLINE_COORDS_FILE = "offline_coords.xml";
    public static final String OFFLINE_COORDS_FILE_VALIDATION = "offline_coords_schema.xsd";
    public static final String XML_IMAGE_TAG = "ImageName";
    public static final String XML_LOCATION_TAG = "Location";
    public static final String XML_ROOT_TAG = "CampusGuesser";
    public static final String XML_X_POSITION_TAG = "X";
    public static final String XML_Y_POSITION_TAG = "Y";
    private List<Element> locations = new ArrayList<Element>();

    public List<Element> getShuffledLocations(int maxEntries) {
        int entriesLength = this.locations.size();
        ArrayList<Element> shuffled = new ArrayList<Element>(this.locations);
        Collections.shuffle(shuffled, new Random());
        if (maxEntries >= entriesLength) {
            return shuffled;
        }
        ArrayList<Element> limitedShuffled = new ArrayList<Element>();
        for (int i = 0; i < maxEntries; ++i) {
            limitedShuffled.add((Element)shuffled.get(i));
        }
        return limitedShuffled;
    }

    public FlatMapParser() {
        try {
            File schemaFile = new File(ConfigParser.getConfigPath() + OFFLINE_COORDS_FILE_VALIDATION);
            XMLReaderXSDFactory factory = new XMLReaderXSDFactory(schemaFile);
            SAXBuilder saxBuilder = new SAXBuilder(factory);
            Document document = saxBuilder.build(new File(ConfigParser.getConfigPath() + OFFLINE_COORDS_FILE));
            Element root = document.getRootElement();
            if (!this.validateRootElement(root)) {
                System.out.println("Invalid root element found in offline_coords.xml. Ignoring.");
            } else {
                this.locations = root.getChildren(XML_LOCATION_TAG);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to parse the offline coordinate config holder XML file for the images. Consider this a failure. (Malformed XML or missing file) ");
            System.out.println("Path: " + ConfigParser.getConfigPath() + OFFLINE_COORDS_FILE_VALIDATION);
        }
    }

    private boolean validateRootElement(Element root) {
        return true == XML_ROOT_TAG.equals(root.getName());
    }

    public FlatMapCoordinate getOfflineCoordsForImg(String img_name) {
        try {
            for (Element loc : this.locations) {
                if (!img_name.equals(loc.getChild(XML_IMAGE_TAG).getText())) continue;
                double x = Double.parseDouble(loc.getChildText(XML_X_POSITION_TAG));
                double y = Double.parseDouble(loc.getChildText(XML_Y_POSITION_TAG));
                return new FlatMapCoordinate(x, y);
            }
        }
        catch (Exception e) {
            System.out.println("Got invalid or null value in the offline coordinate registry.");
        }
        return null;
    }
}

