/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class LangParser {
    private static Map<String, String> map = new HashMap<String, String>();

    public LangParser(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build(file);
                Element root = document.getRootElement();
                List<Element> entries = root.getChildren("entry");
                for (Element entry : entries) {
                    String key = entry.getAttributeValue("key");
                    String value = entry.getText();
                    map.put(key, value);
                }
            }
            catch (Exception e) {
                System.err.println("Error reading the file: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("File does not exist: " + path);
        }
    }

    public static String getLang(String what) {
        String val = map.get(what);
        if (val == null) {
            return "INVALID_LANG_ENTRY";
        }
        return val;
    }
}

