/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat;

import hu.afghangoat.LangEntry;
import hu.afghangoat.Main;
import hu.afghangoat.widgets.StyleWidget;
import java.awt.Color;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ConfigParser {
    private static String game_title;
    private static String CONFIG_PATH;
    private static String IMAGE_PATH;
    private static String LANGS_PATH;
    public static final String TOP_LIST_FILE_SAVE = "top_list.PRIVATE";
    private List<LangEntry> languages = new ArrayList<LangEntry>();
    private String DEFAULT_LANG;
    private String curLang = this.DEFAULT_LANG = "en";
    public static boolean USES_GPS;
    private double langIconScale = 0.3;

    public static String getConfigPath() {
        return CONFIG_PATH;
    }

    public static String getImagePath() {
        return IMAGE_PATH;
    }

    public static String getLangsPath() {
        return LANGS_PATH;
    }

    public static String getTitle() {
        return game_title;
    }

    public double getLangIconScale() {
        return this.langIconScale;
    }

    public List<LangEntry> getLanguages() {
        return this.languages;
    }

    public ConfigParser() {
        Path jarLocation;
        try {
            jarLocation = Paths.get(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Path configPath = jarLocation.getParent().resolve("config");
        CONFIG_PATH = configPath.toAbsolutePath().toString() + "\\";
        IMAGE_PATH = CONFIG_PATH + "images\\";
        LANGS_PATH = CONFIG_PATH + "langs\\";
        File configFile = new File(CONFIG_PATH + "\\config.xml");
        if (configFile.exists()) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build(configFile);
                Element rootElement = document.getRootElement();
                Element languagesElement = rootElement.getChild("languages");
                List<Element> languageElements = languagesElement.getChildren("language");
                for (Element lang : languageElements) {
                    String code = lang.getAttributeValue("code");
                    String name = lang.getText();
                    this.registerLang(code, name);
                }
                String activeLang = rootElement.getChildText("active_lang");
                game_title = rootElement.getChildText("guesser_name");
                this.setCurrentLang(activeLang);
            }
            catch (Exception e) {
                System.err.println("Error reading the file: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("File does not exist: config.xml");
        }
    }

    public void setCurrentLang(String what) {
        this.curLang = what;
    }

    public String getCurrentLang() {
        return this.curLang;
    }

    public void registerLang(String langName, String langTooltip) {
        if (this.languages != null) {
            this.languages.add(new LangEntry(langName, langTooltip));
        }
    }

    public ArrayList<StyleWidget> getThemes(String path) {
        ArrayList<StyleWidget> themes = new ArrayList<StyleWidget>();
        File file = new File(path);
        if (file.exists()) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build(file);
                Element root = document.getRootElement();
                List<Element> entries = root.getChildren("entry");
                for (Element entry : entries) {
                    Element bg1 = entry.getChild("background_gradient_1");
                    Element bg2 = entry.getChild("background_gradient_2");
                    Element font = entry.getChild("font_color");
                    if (bg1 == null || bg2 == null || font == null) {
                        System.out.println("Warning: invalid theme in theme file: " + entry.getAttributeValue("key"));
                        continue;
                    }
                    Element bg1r = bg1.getChild("r");
                    Element bg1g = bg1.getChild("g");
                    Element bg1b = bg1.getChild("b");
                    Element bg2r = bg2.getChild("r");
                    Element bg2g = bg2.getChild("g");
                    Element bg2b = bg2.getChild("b");
                    Element ftr = font.getChild("r");
                    Element ftg = font.getChild("g");
                    Element ftb = font.getChild("b");
                    if (bg1r == null || bg1g == null || bg1b == null || bg2r == null || bg2g == null || bg2b == null || ftr == null || ftg == null || ftb == null) {
                        System.out.println("Warning: invalid theme in theme file: " + entry.getAttributeValue("key"));
                        continue;
                    }
                    themes.add(new StyleWidget(new Color(Integer.parseInt(bg1r.getText()), Integer.parseInt(bg1g.getText()), Integer.parseInt(bg1b.getText())), new Color(Integer.parseInt(bg2r.getText()), Integer.parseInt(bg2g.getText()), Integer.parseInt(bg2b.getText())), new Color(Integer.parseInt(ftr.getText()), Integer.parseInt(ftg.getText()), Integer.parseInt(ftb.getText())), entry.getAttributeValue("key")));
                }
            }
            catch (Exception e) {
                System.err.println("Error reading the file: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("File does not exist: " + path);
        }
        return themes;
    }

    static {
        CONFIG_PATH = "";
        IMAGE_PATH = "";
        LANGS_PATH = "";
        USES_GPS = false;
    }
}

