package test;

import junitlab.bank.AccountNotExistsException;
import junitlab.bank.impl.FirstNationalBank;
import junitlab.bank.impl.GreatSavingsBank;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import static org.junit.Assert.assertNotEquals;
import static org.junit.jupiter.api.Assertions.assertDoesNotThrow;
import static org.junit.jupiter.api.Assertions.assertThrows;

public class GreatSavingsBankTest {

    @Test
    void testOpenAccount(){
        GreatSavingsBank b1 = new GreatSavingsBank();

        String accountName = b1.openAccount();

        assertDoesNotThrow(() -> {
            long bal = b1.getBalance(accountName);
            Assertions.assertEquals(bal, 0);
        });


    }

    @Test
    void testUniqueAccount(){
        GreatSavingsBank b1 = new GreatSavingsBank();

        String accountName1 = b1.openAccount();
        String accountName2 = b1.openAccount();

        assertNotEquals(accountName1,accountName2);
    }

    //Ez a hibás teszt, mert nem dobja az elvárt AccountNotExistsException exception-t, pedig az lenne az elvárt viselkedést.
    @Test
    void testInvalidAccount(){
        GreatSavingsBank b1 = new GreatSavingsBank();

        String accountName = "nonexistentaccount544";
        assertThrows(AccountNotExistsException.class, () -> {
            b1.getBalance(accountName);
        });

    }

    @Test
    void testDeposit(){
        GreatSavingsBank b1 = new GreatSavingsBank();

        String accountName = b1.openAccount();

        assertDoesNotThrow(() -> {
            b1.deposit(accountName,2000);
            long bal = b1.getBalance(accountName);
            Assertions.assertEquals(bal, 2000);
        });


    }
}
