package test;

import junitlab.bank.AccountNotExistsException;
import junitlab.bank.NotEnoughFundsException;
import junitlab.bank.impl.FirstNationalBank;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

import static org.junit.jupiter.api.Assertions.*;

public class BankTestFixture {

    public static FirstNationalBank globalBank;

    public static String accountName1 = "";
    public static String accountName2 = "";

    @BeforeAll
    public static void setUp(){
        globalBank = new FirstNationalBank();

        accountName1 = globalBank.openAccount();
        accountName2 = globalBank.openAccount();

        assertDoesNotThrow(() -> {
            globalBank.deposit(accountName1, 1500);
            globalBank.deposit(accountName2, 12000);
        });
    }

    @Test
    void testTransfer() throws AccountNotExistsException {
        assertDoesNotThrow(() -> {
            globalBank.transfer(accountName2,accountName1,3456);
        });

        assertEquals(globalBank.getBalance(accountName1),4956);
        assertEquals(globalBank.getBalance(accountName2),8544);
    }

    @Test
    void testTransferWithoutEnoughFunds(){
        assertThrows(NotEnoughFundsException.class, () -> {
            globalBank.transfer(accountName1,accountName2,3456);
        });
    }
}
