package test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.jupiter.api.Assertions.*;

import junitlab.bank.AccountNotExistsException;
import junitlab.bank.impl.FirstNationalBank;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BankTest {

    @Test
    void testOpenAccount(){
        FirstNationalBank b1 = new FirstNationalBank();

        String accountName = b1.openAccount();

        assertDoesNotThrow(() -> {
            long bal = b1.getBalance(accountName);
            Assertions.assertEquals(bal, 0);
        });


    }

    @Test
    void testUniqueAccount(){
        FirstNationalBank b1 = new FirstNationalBank();

        String accountName1 = b1.openAccount();
        String accountName2 = b1.openAccount();

        assertNotEquals(accountName1,accountName2);
    }

    //Ez a hibás teszt, mert nem dobja az elvárt AccountNotExistsException exception-t, pedig az lenne az elvárt viselkedést.
    @Test
    void testInvalidAccount(){
        FirstNationalBank b1 = new FirstNationalBank();

        String accountName = "nonexistentaccount544";
        assertThrows(AccountNotExistsException.class, () -> {
            b1.getBalance(accountName);
        });

    }

    @Test
    void testDeposit(){
        FirstNationalBank b1 = new FirstNationalBank();

        String accountName = b1.openAccount();

        assertDoesNotThrow(() -> {
            b1.deposit(accountName,2000);
            long bal = b1.getBalance(accountName);
            Assertions.assertEquals(bal, 2000);
        });


    }
}
