package test;

import junitlab.bank.impl.FirstNationalBank;
import junitlab.bank.impl.GreatSavingsBank;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.assertDoesNotThrow;
import static org.junit.jupiter.api.Assertions.assertEquals;

public class BankParamTest {
    //
    @ParameterizedTest
    @MethodSource("parameters")
    void testWithdrawRounding(long[] params){
        long rounded = params[0];
        long amount = params[1];
        FirstNationalBank b1 = new FirstNationalBank();

        String account1 = b1.openAccount();

        assertDoesNotThrow(() -> {
            b1.deposit(account1,10000);

            b1.withdraw(account1,amount);

            assertEquals(10000-rounded,b1.getBalance(account1));
        });
    }

    @ParameterizedTest
    @MethodSource("parameters")
    void testWithdrawRoundingGreat(long[] params){
        long rounded = params[0];
        long amount = params[1];
        GreatSavingsBank b1 = new GreatSavingsBank();

        String account1 = b1.openAccount();

        assertDoesNotThrow(() -> {
            b1.deposit(account1,10000);

            b1.withdraw(account1,amount);

            assertEquals(10000-rounded,b1.getBalance(account1));
        });
    }

    public static Stream<long[]> parameters() {
        List<long[]> params = new ArrayList<long []>();

        params.add(new long[] {1100, 1100});
        params.add(new long [] {1100, 1101});
        params.add(new long [] {1100, 1149});
        params.add(new long [] {1200, 1150});
        params.add(new long [] {1200, 1151});
        params.add(new long [] {1200, 1199});
        params.add(new long [] {1200, 1200});
        return params.stream();
    }
}
