package junitlab.bank;

/**
 * A bankkal kapcsolatos kivtelek sosztlya.
 */
public abstract class BankException extends Exception {

	/**
	 * A szmlaszm, amelynl a hiba fellpett.
	 */
	private String accountNumber;

	/**
	 * A kivtel ltrehozsa.
	 * @param accountNumber A szmlaszm, amelynl a hiba fellpett.
	 */
	public BankException(String accountNumber) {
		super();
		this.accountNumber = accountNumber;
	}
	
	/**
	 * A kivtel ltrehozsa az adott hibazenettel.
	 * @param accountNumber A szmlaszm, amelynl a hiba fellpett.
	 * @param message A hibazenet szvege.
	 */
	public BankException(String accountNumber, String message) {
		super(message);
		this.accountNumber = accountNumber;
	}
	
	/**
	 * A hibt okoz szmlaszm lekrdezse.
	 * @return A szmlaszm, amelynl a kivtel fellpett.
	 */
	public String getAccountNumber() {
		return accountNumber;
	}
}
