package junitlab.bank;

/**
 * Egy kezdetleges takarkszvetkezet interfsze.
 * Alapvet szmlakezelsi mveleteket definil.  
 */
public interface Bank {

	/**
	 * Egy j szmla megnyitsa. A szmln kezdetben nulla az egyenleg.
	 * @return A frissen ltrejtt szmla szma.
	 */
	public String openAccount();
	
	/**
	 * res szmla megszntetse.
	 * @param accountNumber A megszntetend szmlaszm.
	 * @return Sikerlt-e elvgezni a mveletet. Ha a szmla egyenlege nem nulla, nem lehet megszntetni.
	 * @throws AccountNotExistsException Ha a megadott szmlaszm nem ltezik.
	 */
	public boolean closeAccount(String accountNumber) throws AccountNotExistsException;
	
	/**
	 * Az aktulis egyenleg lekrdezse.
	 * @param accountNumber A krdses szmlaszm.
	 * @return Az egyenleg.
	 * @throws AccountNotExistsException Ha a megadott szmlaszm nem ltezik.
	 */
	public long getBalance(String accountNumber) throws AccountNotExistsException;
	
	/**
	 * Egy adott sszeg befizetse a szmlra. Technikai okokbl csak 100-zal
	 * oszthat sszegeket lehet befizetni a szmlra. Az ettl eltr sszegeket
	 * a kerekts szablyai szerint kell kezelni.
	 * @param accountNumber A feltltend szmlaszm.
	 * @param amount A befizetend sszeg. Mindig pozitvnak kell lennie.
	 * @throws AccountNotExistsException Ha a megadott szmlaszm nem ltezik.
	 */
	public void deposit(String accountNumber, long amount) throws AccountNotExistsException;
	
	/**
	 * Egy adott sszeg kivtele a szmlrl. Technikai okokbl csak 100-zal
	 * oszthat sszegeket lehet kifizetni a szmlrl. Az ettl eltr sszegeket
	 * a kerekts szablyai szerint kell kezelni.
	 * @param accountNumber A terhelend szmlaszm.
	 * @param amount A kifizetend sszeg. Mindig pozitvnak kell lennie.
	 * @throws AccountNotExistsException Ha a megadott szmlaszm nem ltezik.
	 * @throws NotEnoughFundsException Ha kevesebb pnz van a szmln, mint amit megadtunk.
	 */
	public void withdraw(String accountNumber, long amount) throws AccountNotExistsException, NotEnoughFundsException;
	
	/**
	 * Egy adott sszeg tutalsa egyik szmlrl a msikra. Az tutalsokra
	 * nem vonatkozik a szzas kerektsi szably, tetszleges sszeg tutalhat. 
	 * @param sourceAccount A terhelend szmlaszm.
	 * @param targetAccount A cl szmlaszm, amire utalunk.
	 * @param amount A kifizetend sszeg. Mindig pozitvnak kell lennie.
	 * @throws AccountNotExistsException Ha a megadott szmlaszm nem ltezik.
	 * @throws NotEnoughFundsException Ha kevesebb pnz van a forrsszmln, mint amit t akarunk utalni.
	 */
	public void transfer(String sourceAccount, String targetAccount, long amount) throws AccountNotExistsException, NotEnoughFundsException;
}
