
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import javax.swing.*;

public class CaesarFrame extends JFrame{

    private JTextField textField = new JTextField(20);
    private JButton button;
    private JComboBox<String> comboBox;
    JTextField outputText;

    public CaesarFrame(){
        setTitle("SwingLab");
        setSize(400,110);
        setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

        JPanel contentPanel1 = new JPanel();

        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
        contentPanel1.setLayout(new BoxLayout(contentPanel1, BoxLayout.X_AXIS));
        setContentPane(mainPanel);

        // JComboBox instead of left label
        String[] options = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("");
        comboBox = new JComboBox<>(options);



        button = new JButton("Code!");

        contentPanel1.add(comboBox);
        contentPanel1.add(textField);
        contentPanel1.add(button);

        JPanel contentPanel2 = new JPanel();
        contentPanel2.setLayout(new BoxLayout(contentPanel2, BoxLayout.X_AXIS));

        JLabel label = new JLabel("Output:");
        outputText = new JTextField(20);
        outputText.setEnabled(false);

        contentPanel2.add(label);
        contentPanel2.add(outputText);

        // Add both rows to main panel
        mainPanel.add(contentPanel1);
        mainPanel.add(contentPanel2);

        button.addActionListener(new OkButtonActionListener());

        pack();
        setLocationByPlatform(true);

        setResizable(true); //Átméretezhető.
    }

    class OkButtonActionListener implements ActionListener{

        @Override
        public void actionPerformed(ActionEvent e) {
            outputText.setText(caesarCode(textField.getText(),comboBox.getSelectedItem().toString().charAt(0)));
        }
    }

    private String caesarCode(String input, char offset){
        //int offsetN = offset-'a';
        String newCode = "";

        for(int i=0;i<input.length();i++){
            if(input.charAt(i) == ' '){
                newCode+=' ';
                continue;
            }

            boolean isLower = Character.isLowerCase(input.charAt(i));

            char paddingChar = isLower ? 'a' : 'A';

            int charCode = input.charAt(i)-paddingChar;

            charCode += (offset-paddingChar);
            charCode %=26;

            newCode+=(char) (charCode +paddingChar);

        }

        return newCode;
    }


}
