import java.util.ArrayList;

public class Fifo extends Thread{
    public static final int MAX_SIZE =10;
    ArrayList<String> list = new ArrayList<>();

    public synchronized void put(String s) throws InterruptedException {
        while (list.size() >= MAX_SIZE) {
            wait();
        }
        list.add(s);

        notifyAll();
        System.out.println("put "+getId());
    }

    public synchronized String get() throws InterruptedException {
        while (list.isEmpty()) {
            wait();
        }
        String value = list.remove(0);
        notifyAll();
        System.out.println("get "+getId());
        return value;
    }
}
