import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PQueue<T extends Comparable> implements Iterable<T>{
    ArrayList<T> list = new ArrayList<>();

    public PQueue(ArrayList<T> list) {
        this.list = list;
    }
    public PQueue() {
        this.list = new ArrayList<>();
    }

    public void push(T t){
        list.add(t);

    }
    public T pop() throws EmptyQueueException {
        if(size()==0){
            throw new EmptyQueueException("Nincs semmi a PQueue-ban!");
        }
        T maxelem = (T) Collections.max(list);
        list.remove(maxelem);
        return maxelem;
    }
    public T top() throws EmptyQueueException {
        if(size()==0){
            throw new EmptyQueueException("Nincs semmi a PQueue-ban!");
        }
        return (T) Collections.max(list);
    }

    public int size(){
        return list.size();
    }

    public void clear(){
        list.clear();
    }

    @Override
    public Iterator iterator() {
        return list.iterator();
    }

    @Override
    public void forEach(Consumer action) {
        list.forEach(action);
    }

    @Override
    public Spliterator spliterator() {
        return list.spliterator();
    }
}
