import java.io.*;
import java.nio.channels.FileChannel;
import java.util.*;

public class BeerParser{

    private final Scanner scanner = new Scanner(System.in);

    private ArrayList<Beer> list = new ArrayList<>();

    BeerParser(){

    }
    void startParsing(){

        while (true) {
            String input = scanner.nextLine();
            String[] cmd = input.split(" ");

            //System.out.println("1. Elem: " + cmd[0] + ", tömb mérete: " + cmd.length);
            if (cmd[0].equals("add")) {
                cmdAdd(cmd);
            } else if (cmd[0].equals("list")) {
                cmdList(cmd);
            } else if (cmd[0].equals("load")) {
                cmdLoad(cmd);
            } else if (cmd[0].equals("save")) {
                cmdSave(cmd);
            } else if (cmd[0].equals("search")) {
                cmdSearch(cmd);
            } else if (cmd[0].equals("find")) {
                cmdFind(cmd);
            } else if (cmd[0].equals("delete")) {
                cmdDelete(cmd);
            } else if (cmd[0].equals("exit")) {
                break;
            }
        }
    }

    protected void cmdAdd(String[] cmd){
        list.add(new Beer(cmd[1],cmd[2],Double.parseDouble(cmd[3])));
    }

    protected void cmdList(String[] cmd){
        if(cmd.length>1){
            String basedOn = cmd[1];
            if(basedOn.equals("name")){
                list.sort(new NameComparator());
            } else if(basedOn.equals("strength")){
                list.sort(new StrengthComparator());
            } else if(basedOn.equals("style")){
                list.sort(new StyleComparator());
            }
        }


        for(int i=0;i<list.size();i++){
            System.out.println(list.get(i)+"\n----------------\n");
        }
    }

    protected void cmdSearch(String[] cmd){
        String basedOn = "name";
        String param="";
        if(cmd.length==2){
            param = cmd[1];
        } else {
            basedOn = cmd[1];
            param = cmd[2];
        }

        if(basedOn.equals("name")){
            for (Beer beer : list) {
                if(beer.getName().equals(param)){
                    System.out.println(beer+"\n----------------\n");
                }

            }
        } else if(basedOn.equals("style")){
            for (Beer beer : list) {
                if(beer.getStyle().equals(param)){
                    System.out.println(beer+"\n----------------\n");
                }

            }
        } else if(basedOn.equals("strength")){
            for (Beer beer : list) {
                if(beer.getStrength() == Double.parseDouble(param)){
                    System.out.println(beer+"\n----------------\n");
                }

            }
        }



    }

    protected void cmdFind(String[] cmd){
        String basedOn = "name";
        String param="";
        if(cmd.length==2){
            param = cmd[1];
        } else {
            basedOn = cmd[1];
            param = cmd[2];
        }

        if(basedOn.equals("name")){
            for (Beer beer : list) {
                if(beer.getName().contains(param)){
                    System.out.println(beer+"\n----------------\n");
                }

            }
        } else if(basedOn.equals("style")){
            for (Beer beer : list) {
                if(beer.getStyle().contains(param)){
                    System.out.println(beer+"\n----------------\n");
                }

            }
        } else if(basedOn.equals("strength")){
            for (Beer beer : list) {
                if(beer.getStrength() >= Double.parseDouble(param)){
                    System.out.println(beer+"\n----------------\n");
                }

            }
        } else if(basedOn.equals("weaker")){
            for (Beer beer : list) {
                if(beer.getStrength() <= Double.parseDouble(param)){
                    System.out.println(beer+"\n----------------\n");
                }

            }
        }

    }

    protected void cmdDelete(String[] cmd){
        String param = cmd[1];
        Iterator<Beer> it = list.iterator();

        while(it.hasNext()){
            if(it.next().getName().equals(param)){
                it.remove();
            }
        }

    }

    protected void cmdLoad(String[] cmd){

        list.clear();
        String filename = cmd[1];
        try {
            FileInputStream file = new FileInputStream(filename);
            ObjectInputStream in = new ObjectInputStream(file);
            list = (ArrayList<Beer>) in.readObject();

            in.close();
            file.close();

        } catch (IOException ex) {
            System.out.println("IOException hiba!");
        } catch (ClassNotFoundException ex) {
            System.out.println("ClassNotFoundException hiba! (Nincs beer class)");
        }

    }
    public void cmdSave(String[] cmd){
        String filename = cmd[1];

        try {
            FileOutputStream file = new FileOutputStream(filename);
            ObjectOutputStream out = new ObjectOutputStream(file);
            out.writeObject(list);
            out.close();
            file.close();
            System.out.println("Serializálás sikeres.");

        } catch (IOException ex) {
            System.out.println("IOException hiba!");
        }
    }

}
