#include <tuple>
#include <iostream>
#include <variant>

void print_sum(int a, int b, int c) {
    std::cout << (a + b + c) << "\n";
}

template<class... Ts>
struct overloaded : Ts... {
    using Ts::operator()...;
};
// CTAD (C++17)
template<class... Ts> overloaded(Ts...) -> overloaded<Ts...>;

int main() {
    std::tuple<int, int, int> t = {1, 2, 3};
    std::apply(print_sum, t); // --> print_sum(1, 2, 3)
    
    std::apply([](auto a, auto b){
        std::cout << a + b << std::endl;
    
    }, std::make_tuple(4, 5));
    
    std::variant<int, std::string> v2 = "Hello";

    std::visit([](auto&& arg){
        std::cout << arg << "\n";
    }, v2);
    
    std::variant<int, std::string, double> v = 3.14;

    std::visit(overloaded{
        [](int i){ std::cout << "int: " << i << "\n"; },
        [](const std::string& s){ std::cout << "string: " << s << "\n"; },
        [](double d){ std::cout << "double: " << d << "\n"; }
    }, v);
}