#include <iostream>

template<typename... Args> //sablonparaméter-csomag
void printAll(Args... args) { //függvényparaméter-csomag
    (std::cout << ...  << args) << '\n'; // fold expression (C++17+)
    
    //Rekurzívan is lehet
}

template<typename... Args>
auto sum(Args... args) {
    return (args + ...); // unáris bal fold
}

template<typename... Args>
auto sum2(Args... args) {
    return (... + args); // unáris bal fold
}

template<typename T>
void inspect(T val) {
    if constexpr (std::is_integral_v<T>)
        std::cout << val << " is an integer\n";
    else if constexpr (std::is_floating_point_v<T>)
        std::cout << val << " is a float\n";
    else
        std::cout << val << " is something else\n";
}

template<typename T>
void print_impl(T val, std::true_type) {
    std::cout << val << " (integral)\n";
}

template<typename T>
void print_impl(T val, std::false_type) {
    std::cout << val << " (non-integral)\n";
}

template<typename T>
void printType(T val) {
    print_impl(val, std::is_integral<T>{}); //A 2. eldöntés alapján dönt a fordító.
}

//Substitution Failure Is Not An Error
template<typename T, typename... Args>
auto sum_sfinae(T a, Args... args) -> std::enable_if_t<std::is_arithmetic_v<T>, T>{
    return (a + ... + args);
}

//Feladatok:

//1.
template<typename... Args>
auto constexprSum(Args... args){
    return (... + args);
}

//2
/*template<typename T, typename U, typename... Rest>
void countTypesHelper(U first, Rest... rest){
    if(std::is_same<T,U>{}){
        std::cout << "found one";
    }
    
    countTypesHelper<T>(rest...);
}*/

template<typename U,typename T, typename... Rest>
size_t countTypesHelper(T first, Rest... rest) {
    size_t found = 0;
    if(std::is_same<T,U>{}){
        std::cout << "found one:" << first<< std::endl;
        found=1;
    }
    
    if constexpr (sizeof...(Rest) > 0) { //Lehet ilyet is csinálni
        found += countTypesHelper<U>(rest...);
    }
    return found;
}

//Kell egy base case, mert különben sose áll le
template<typename U>
size_t countTypesHelper() {
    return 0;
}

template<typename T, typename... Args>
size_t countTypes(Args... args){
    return countTypesHelper<T>(args...);
}

template<typename T, typename... Args>
void countTypes2(Args... args) {
    ((std::is_same_v<T, Args> ? (std::cout << "found one2: " << args << '\n', 0) : 0), ...);
    
    /*Extracted:
    (
  (std::is_same_v<T, Arg1> ? (std::cout << Arg1, 0) : 0),
  (std::is_same_v<T, Arg2> ? (std::cout << Arg2, 0) : 0),
  ...
);*/
}

//3.

size_t howMuchPercentSymbols(const char* str,size_t index);

//Empty clause
void tprintfhelper(const char* msg) {
    while (*msg) {
        if (*msg == '%') {
            throw std::runtime_error("Hiba! Elfogyott a paraméter de a % nem!");
        }
        std::cout << *msg++;
    }
};
template<typename T, typename... Args>
void tprintfhelper(const char* fmt, T firstarg, Args... rest){
    while(*fmt){
        if(*fmt == '%'){
            //std::cout << firstarg;
            std::cout << std::forward<T>(firstarg);
            fmt++;
            tprintfhelper(fmt, rest...);
            return;
            
        } else {
            std::cout << *fmt;
        }
        fmt++;
    }
}
template<typename... Args>
void tprintf( const char* fmt, Args... rest){
    if (sizeof...(Args) == howMuchPercentSymbols(fmt,0)){
        tprintfhelper(fmt, rest...);
    } else {
        throw std::runtime_error("Invalid amount of parameters received, substitution failed.");
    }
}

//4.
//constexpr
size_t howMuchPercentSymbols(const char* str, size_t index){
    return str[index] =='\0' ? 0: ((str[index] =='%'? 1: 0) +howMuchPercentSymbols(str,index+1));
}

int main() {
    printAll(1, " hello ", 3.14, '!');
    
    std::cout << sum(1, 2, 3, 4) << std::endl; // 10
    std::cout << sum2(1, 2, 3, 4) << std::endl; // 10
    
    inspect(42);
    inspect(3.14);
    inspect("hello");
    
    printType(42);
    printType(3.14);
    
    sum_sfinae(1, 2, 3);      // OK
    //sum_sfinae("a", "b");  // Error: disabled by SFINAE
    
    std::cout << constexprSum(1,2,3,4,5);
    
    
    
    std::cout << countTypes<int>(1, 2.0, 3, "hello", 5);
    countTypes2<int>(1, 2.0, 3, "hello", 5);
    
    tprintf("Hello % and %!\n", "world", 42);
    std::cout << howMuchPercentSymbols("% aas % aa",0);
}