#include <iostream>
#include <utility>
#include <string>
#include <memory>
#include <vector>

struct Thing {
    std::string name;

    Thing(std::string n) : name(std::move(n)) {}
    Thing(const Thing& other) : name(other.name) { std::cout << "Copy\n"; }
    Thing(Thing&& other) noexcept : name(std::move(other.name)) { std::cout << "Move\n"; } // ha noexcept, akkor std::move_if_noexcept move-ol
};

template<typename T>
void wrapper(T&& arg) {
    func(std::forward<T>(arg)); // megőrzi az eredeti "value category"-t, hogy rvalue vagy lvalue-e.
}

class Buffer {
    size_t size;
    char* data;
public:
    Buffer(size_t s){
        size=s;
        data = new char[s];
        fillUp('a');
    }
    void fillUp(char what){
        if(data==nullptr){
            return;
        }
        
        for(int i=0;i<size;i++){
            data[i]=what;
        }
    }
    void printOut(){
        if(data==nullptr){
            return;
        }
        
        for(int i=0;i<size;i++){
            std::cout << data[i] << ", ";
        }
    }
    
    void freeSelf(){
        if(data!=nullptr){
            delete[] data;
            data = nullptr;
        }
    }
    
    ~Buffer(){
        freeSelf();
    }
    Buffer(const Buffer& other){
        //freeSelf();
        size = other.size;
        data = new char[size];
        for(int i=0;i<size;i++){
            data[i] = other.data[i];
        }
    }
    Buffer(Buffer&& other) noexcept: size(std::move(other.size)){
        data = std::move(other.data);
        other.data=nullptr;
        other.size=0;
    }
    Buffer& operator=(const Buffer& other){
        if(this != &other){
            freeSelf();
            size = other.size;
            data = new char[size];
            for(int i=0;i<size;i++){
               data[i] = other.data[i];
            }
        }
        return *this;
    }
    Buffer& operator=(Buffer&& other) noexcept{
        if(this != &other){
            freeSelf();
            size = other.size;
            data = other.data;
            
            other.data = nullptr;
            other.size=0;
        }
        return *this;
    }
};

template<typename T, typename... Args>
std::unique_ptr<T> make_custom(Args&&... args){
    return std::unique_ptr<T>(new T(std::forward<Args>(args)...));
}

template<typename T>
void inspect(T&& x) {
    if constexpr (std::is_lvalue_reference_v<T>) {
        std::cout << "lvalue\n";
    } else {
        std::cout << "rvalue\n";
    }
    
    
}

template<typename T>
class Wrapper{
private:
    T obj;
    std::vector<std::string> logEntry;
    
public:

    template<typename U>
    Wrapper(U&& val): obj(std::forward<U>(val)){
        if constexpr (std::is_lvalue_reference_v<U>){
            logEntry.push_back("Moved (forwarded) Lval from " + (std::string)(typeid(U).name()) + "  to " + (std::string)(typeid(T).name()));
        } else {
            logEntry.push_back("Moved (forwarded) Rval from " + (std::string)(typeid(U).name()) + "  to " + (std::string)(typeid(T).name()));
        }
        
    }
    
    Wrapper(const T& val): obj(val){
        logEntry.push_back("Copied from " + (std::string)(typeid(T).name()) + " to " + (std::string)(typeid(T).name()));
    }
    
    Wrapper(const Wrapper& val): obj(val.obj){
        logEntry.push_back("Copied (Class copy) from " + (std::string)(typeid(T).name()) + " to " + (std::string)(typeid(T).name()));
    }
    
    void log(){
        for(size_t i = 0;i<logEntry.size();i++){
            std::cout << logEntry[i] << std::endl;
        }
    }
    
};

int main() {
    //Thing a("Alpha");
    //Thing b = std::move(a);  // explicit move
    
    Buffer b1(10);
    Buffer b2(5);
    b2.fillUp('b');
    
    Buffer b3 = std::move(b2);
    
    //b3.printOut();
    
    int a = 5;
    inspect(a); //L value, azért mert egy olyan dologra referál, ami egy kifejezésen túl is létezik.
    inspect(5); //R value, azért mert egy olyan számra referál ami csak egy kifejezésben létezik. (Temporary a kifejezésben)
    
    Wrapper<std::string> w1("hello");
    std::string s = "world";
    Wrapper<std::string> w2(s);
    w1.log();
    w2.log(); //Output:
    /*
    Moved (forwarded) from NSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE to NSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE
Moved (forwarded) from NSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE to NSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE*/

    //Magyarázat: Azért forwardol elsőnek is, mert egy Rvalue temporary referencet kap, így nem a copy constructor hívódik meg. Másodszor is a forwardos lesz végrehajtva, mert s nevesített változó de a forward nem castol Rvalue-á.
}