#ifndef GENERAL_SIM_HPP
#define GENERAL_SIM_HPP

#include <memory>
#include <unordered_set>
#include <vector>
#include <iostream>
#include <Eigen/Dense>

#include "../world_pieces/electronics/base_component.hpp"
#include "../world_pieces/electronics/port.hpp"
#include "../world_pieces/electronics/net.hpp"

class GeneralSimulation{ //Will hold the components
	protected:
		std::vector<std::unique_ptr<Net>> nets;
	public:
		std::vector<std::unique_ptr<ElectricalComponent>> components;
		
		std::string validatedText = "";
		bool validated = false;
		
		int getNodeIndex(Net* net);
		
		void addNet(std::unique_ptr<Net> n);
		
		int nodeCount() const;
		
		size_t netAmount() const;
		
		Net* getNet(size_t i);
		
		void addElectricalComponent(std::unique_ptr<ElectricalComponent> e);
		
		virtual void validate() =0;
		
		bool isContainingId(int id, const std::vector<ElectricalComponent*>& v);
		
		size_t componentAmount() const;
		
		ElectricalComponent* getComponent(size_t i);
		
		GeneralSimulation();
		
		template<typename T, typename... Args>
		T& addComponent(Args&&... args);
		
		virtual void solve() =0;
		
		virtual ~GeneralSimulation();
		
		virtual void connectPort(Port* a, Port* b) =0;
		
		virtual void deleteConnection(Node* a, Node* b) =0;
		
		virtual void clear() =0;
		
		virtual void clearElement(Node* n)=0;
};

template<typename T, typename... Args>
T& GeneralSimulation::addComponent(Args&&... args) {
    auto ptr = std::make_unique<T>(std::forward<Args>(args)...);
    T& ref = *ptr;
    components.emplace_back(std::move(ptr));
    return ref;
}

#endif