#include "general_simulation.hpp"

GeneralSimulation::GeneralSimulation(){

}

int GeneralSimulation::nodeCount() const {
	int count = nets.size();
	/*for (auto& net : nets) {
		if (!net->isGND()){
			count++;
		}
	}*/
	return count;
}

size_t GeneralSimulation::netAmount() const{
	return nets.size();
}

int GeneralSimulation::getNodeIndex(Net* net) {
	//assert(net->index >= -1);
	return net->index;
}

void GeneralSimulation::addNet(std::unique_ptr<Net> n){
	n->index = nets.size()-1;
	
	nets.emplace_back(std::move(n));
	
}

Net* GeneralSimulation::getNet(size_t i){
	//TODO boundary check
	return(nets[i].get());
}


size_t GeneralSimulation::componentAmount() const{
	return components.size();
}

ElectricalComponent* GeneralSimulation::getComponent(size_t i){
	//TODO boundary check
	return(components[i].get());
}



bool GeneralSimulation::isContainingId(int id, const std::vector<ElectricalComponent*>& v){
	for(size_t i = 0;i<v.size();i++){
		if(v[i]->getId() == id){
			return true;
		}
	}
	return false;
}

void GeneralSimulation::addElectricalComponent(std::unique_ptr<ElectricalComponent> e){
	components.emplace_back(std::move(e));
}

GeneralSimulation::~GeneralSimulation(){
	
}