#ifndef DIGITAL_SIMULATION_HPP
#define DIGITAL_SIMULATION_HPP

#include <memory>
#include <unordered_set>
#include <vector>
#include <iostream>
#include <Eigen/Dense>

#include "../world_pieces/digital/digital_component.hpp"
#include "../world_pieces/electronics/port.hpp"
#include "../world_pieces/electronics/net.hpp"

#include "general_simulation.hpp"

class DigitalSimulation: public GeneralSimulation{ //Will hold the components
	private:

	public:
		
		void validate() override;
		
		DigitalSimulation();
		
		void solve() override;
		
		void clearElement(Node* n) override;
		
		~DigitalSimulation();
		
		void connectPort(Port* a, Port* b) override;
		
		//void connectPortToNet(Port* p, Net* n);
		
		void deleteConnection(Node* a, Node* b) override;
		
		void clear() override;
		
		bool DFS(size_t i); //Has dag
		bool getNextDepth(ElectricalComponent* c, std::vector<ElectricalComponent*>& explored);
		
		void BFS_simulate(std::vector<DigitalComponent*>& bases,std::unordered_set<DigitalComponent*>& visited);
};

#endif