#ifndef CIRCUIT_SIMULATION_HPP
#define CIRCUIT_SIMULATION_HPP

#include <memory>
#include <unordered_set>
#include <vector>
#include <iostream>
#include <Eigen/Dense>

#include "../world_pieces/electronics/base_component.hpp"
#include "../world_pieces/electronics/port.hpp"
#include "../world_pieces/electronics/net.hpp"

#include "general_simulation.hpp"

class CircuitSimulation: public GeneralSimulation{ //Will hold the components
	private:
		
		int extraVariableCount = 0;
		int voltageSourceCount = 0;
		int nonGNDNodes =0;
		//TODO voltageSourceCount and nodecount CACHE
		
	public:
		Eigen::MatrixXd A;
		Eigen::VectorXd b;
		Eigen::VectorXd x;
		
		void validate() override;
		/*int getNodeIndex(Net* net){
			for(int i=0;i<nets.size();i++){
				if(nets[i].get() == net){
					return i;
				}
			}
			return -1;
		}*/
		
		CircuitSimulation();
		
		int allocateExtraVariable();
		
		void solve() override;
		
		
		
		void clearElement(Node* n) override;
		
		~CircuitSimulation();
		
		
		std::vector<ElectricalComponent*> DFS(size_t i);
		void getNextDepth(ElectricalComponent* c, std::vector<ElectricalComponent*>& explored);
		
		void connectPort(Port* a, Port* b) override;
		
		//void connectPortToNet(Port* p, Net* n);
		
		void deleteConnection(Node* a, Node* b) override;
		
		void clear() override;
};

#endif