#include "resistor.hpp"

Resistor::Resistor(double res): R(res){
	setRequiredPorts(2);
	setName("Resistor_R"+std::to_string(R));
}

void Resistor::stamp(CircuitSimulation& c) {
	assert(ports[0]);
	assert(ports[1]);
	assert(ports[0]->net);
	assert(ports[1]->net);
	
	int n1 = c.getNodeIndex(ports[0]->net); //Error
	int n2 = c.getNodeIndex(ports[1]->net);
	
	float g = 1.0f;
	if(R != 0.0){
		g/=R;
	} else {
		g = RESISTANCE_MAX_VALUE;
	}

	if (n1 != GND_INDEX) {
		c.A(n1,n1) += g;
	}
	if (n2 != GND_INDEX) {
		c.A(n2,n2) += g;
	}
	if (n1 != GND_INDEX && n2 != GND_INDEX) {
		c.A(n1,n2) -= g;
		c.A(n2,n1) -= g;
	}
}

void Resistor::updateCurrentAndPower(const CircuitSimulation& c){
	double V1 = ports[0]->net->voltage;
	double V2 = ports[1]->net->voltage;
	lastCurrent = (V1 - V2) / R;
	lastVoltage = V1-V2;
	lastPower = lastCurrent * lastCurrent * R;
}

/*void Resistor::setSimulatedString(){
	stats = getName() + ": \n" +"\tCurrent: " + std::to_string(lastCurrent) + " A\n"+"\tVoltage: " + std::to_string(lastVoltage) + " V\n"+"\tPower: "  +std::to_string(lastPower) + " W\n\tResistance: "+std::to_string(R)+" Ohm\n------------------\n";
}*/