#include "op_amp.hpp"



OpAmp::OpAmp(double A) : gain(A) {
	setRequiredPorts(3); // +, -, output
	setName("OpAmp");
}

void OpAmp::stamp(CircuitSimulation& c) {
	int n_plus = c.getNodeIndex(ports[0]->net);
	int n_minus = c.getNodeIndex(ports[1]->net);
	int n_out = c.getNodeIndex(ports[2]->net);

	// Treat as a voltage source: Vout = gain * (V+ - V-)
	k_val = c.allocateExtraVariable();

	if(n_out != GND_INDEX) {
		c.A(n_out,k_val) += 1;
		c.A(k_val,n_out) += 1;
	}
	if(n_plus != GND_INDEX){
		c.A(k_val,n_plus) -= gain;
	}
	if(n_minus != GND_INDEX){
		c.A(k_val,n_minus) += gain;
	}

	c.b[k_val] += 0; // right-hand side
}

void OpAmp::updateCurrentAndPower(const CircuitSimulation& c) {
	double Vout = ports[2]->net->voltage;
	lastVoltage = Vout;
	lastCurrent = c.x[k_val];
	lastPower = lastVoltage * lastCurrent;
}
