#include "npn_transistor.hpp"



NPNTransistor::NPNTransistor() {
	setRequiredPorts(3); // B, C, E
	setName("NPN_Transistor");
}

void NPNTransistor::stamp(CircuitSimulation& c) {
	int nB = c.getNodeIndex(ports[0]->net);
	int nC = c.getNodeIndex(ports[1]->net);
	int nE = c.getNodeIndex(ports[2]->net);

	double Vbe = ports[0]->net->voltage - ports[2]->net->voltage;
	double Ic = Is * (exp(Vbe/0.025)-1);
	//double Ib = Ic / beta;

	//(G = dI/dV)
	double Gbe = Ic / 0.025;


	if(nB != GND_INDEX && nE != GND_INDEX) {
		c.A(nB,nB) += Gbe;
		c.A(nB,nE) -= Gbe;
		c.A(nE,nB) -= Gbe;
		c.A(nE,nE) += Gbe;
	}

	if(nC != GND_INDEX && nE != GND_INDEX) {

		if(nC != GND_INDEX){
			c.b[nC] -= Ic;
		}
		if(nE != GND_INDEX){
			c.b[nE] += Ic;
		}
	}
}

void NPNTransistor::updateCurrentAndPower(const CircuitSimulation& c) {
	double Vbe = ports[0]->net->voltage - ports[2]->net->voltage;
	double Vce = ports[1]->net->voltage - ports[2]->net->voltage;

	lastCurrent = Is * (exp(Vbe/0.025)-1); // collector current approx
	lastVoltage = Vce;
	lastPower = lastVoltage * lastCurrent;
}

