#include "logical_pin.hpp"



LogicalPin::LogicalPin(double v, double iLimit) : voltageLevel(v), maxCurrent(iLimit) {
	setRequiredPorts(1); // one pin
	setName("LogicalPin");
}

void LogicalPin::stamp(CircuitSimulation& c) {
	int n = c.getNodeIndex(ports[0]->net);
	if(n != GND_INDEX) {
		// Ideal voltage source with series resistance for current limit
		double Rs = voltageLevel / maxCurrent;
		c.A(n,n) += 1.0 / Rs;
		c.b[n] += voltageLevel / Rs;
	}
}

void LogicalPin::setLevel(double v) {
	voltageLevel = v;
}

void LogicalPin::updateCurrentAndPower(const CircuitSimulation& c) {
	double V = ports[0]->net->voltage;
	lastCurrent = (voltageLevel - V) / (voltageLevel / maxCurrent);
	lastVoltage = V;
	lastPower = V * lastCurrent;
}
