#ifndef DIODE_HPP
#define DIODE_HPP

#include "base_component.hpp"
#include "port.hpp"
#include "net.hpp"
#include "../../world_simulators/circuit_simulation.hpp"

class Diode: public ElectricalComponent {
	private:
		double Is = 1e-12; // Saturation current
		double n = 1.0;    // Ideality factor
		double Vt = 0.025; // Thermal voltage ~25mV
		
	public:
		Diode();

		void stamp(CircuitSimulation& c) override;

		void updateCurrentAndPower(const CircuitSimulation& c) override;
};

#endif