#include "base_component.hpp"
	
static int UID_giver=0;
	
const std::vector<Port*>& ElectricalComponent::getPorts() const {
	return ports;
	
}

ElectricalComponent::ElectricalComponent(){
    // ports vector auto-initializes
}

int ElectricalComponent::getId() const{
	return id;
}

bool ElectricalComponent::isGND() const{
	return false;
}

void ElectricalComponent::setLastVoltage(double v){
	lastVoltage = v;
}

bool ElectricalComponent::isVoltageSource() const{
	return false;
}

bool ElectricalComponent::isCurrentSource() const{
	return false;
}

void ElectricalComponent::setName(const std::string& n){
	if(has_name == true){
		//TODO error log already has name
		return;
	}
	has_name = true;
	name = n;
	
	id = UID_giver++;
	
	name += NAME_DELIMITER;
	name += std::to_string(id);
}

void ElectricalComponent::setPosition(double x, double y){
	Node::setPosition(x,y);
	
	size_t count = std::min(ports.size(), portOffsets.size());
	
	double rad = rotation * M_PI / 180.0;

	double cosA = std::cos(rad);
	double sinA = std::sin(rad);

	for (size_t i = 0; i < count; i++) {
		double ox = portOffsets[i].x;
		double oy = portOffsets[i].y;

		double rotatedX = ox * cosA - oy * sinA;
		double rotatedY = ox * sinA + oy * cosA;

		ports[i]->setPosition(
			x + rotatedX,
			y + rotatedY
		);
	}
	
	if(serializedRef != nullptr){
		serializedRef->position.x = x;
		serializedRef->position.y = y;
	}
}

void ElectricalComponent::setRotation(double deg){
	rotation = deg;
	
	setPosition(getPosition().x,getPosition().y);
	
	if(serializedRef != nullptr){
		serializedRef->rotation = deg;
	}
}

void ElectricalComponent::setSerializedRef(CustomElectricalComponent* _serializedRef){
	serializedRef = _serializedRef;
	serializedRef->id = id;
	
	for(size_t i =0;i<ports.size();i++){
		ports[i]->serializedRef = _serializedRef;
	}
}

void ElectricalComponent::setSimulatedString(){
	stats = getName() + ": \n" +"\tCurrent: " + std::to_string(lastCurrent) + " A\n"+"\tVoltage: " + std::to_string(lastVoltage) + " V\n"+"\tPower: "  +std::to_string(lastPower) + " W\n------------------\n";
}

const char* ElectricalComponent::getStats() const {
	return stats.c_str();
}


void ElectricalComponent::debugPrint() const {
	std::cout << getName() << ": " << std::endl;
	std::cout << "\tCurrent:" << lastCurrent << "A"<< std::endl;
	std::cout << "\tVoltage:" << lastVoltage << " V"<< std::endl;
	std::cout << "\tPower:" << lastPower << " W"<< std::endl;
	std::cout << "------------------" << std::endl;
}


void ElectricalComponent::addPort(){
	if(ports.size() < required_ports){
		Port* p1 = new Port(this);
		p1->index = static_cast<int>(ports.size());
		ports.push_back(p1);
	}
}

void ElectricalComponent::setRequiredPorts(size_t num){
	required_ports = num;
	for(size_t i = 0;i<required_ports;i++){
		addPort();
	}
}

Port* ElectricalComponent::getPort(size_t idx){
	if(idx>=ports.size()){
		//TODO error
		return nullptr;
	}
	return ports[idx];
}

Port* ElectricalComponent::getNearestPort(double x, double y){
    if (ports.empty()){
        return nullptr;
	}

    Port* nearest = nullptr;
    float bestDistSq = std::numeric_limits<float>::max();

    for (Port* port : ports){
        if (!port) {
            continue;
		}

        ImVec2 pos = port->getPosition();

        float dx = pos.x - x;
        float dy = pos.y - y;
        float distSq = dx * dx + dy * dy;

        if (distSq < bestDistSq){
            bestDistSq = distSq;
            nearest = port;
        }
    }

    return nearest;
}

ElectricalComponent::~ElectricalComponent(){
	if(serializedRef != nullptr){
		//std::cout << "YEEEEESS";
		serializedRef->selfComp = nullptr;
	}
	
	for(size_t i = 0;i<ports.size();i++){
		if(ports[i] != nullptr){
			delete ports[i];
			ports[i] = nullptr;
		}
		
	}
}

void ElectricalComponent::setOffsets(const std::vector<ImVec2>& os){
	portOffsets = os;
}

double ElectricalComponent::getCurrent() const {
	return lastCurrent;
}

double ElectricalComponent::getPower() const {
	return lastPower;
}
double ElectricalComponent::getVoltage() const {
	return lastVoltage;
}