#include "xor_gate.hpp"

XorGate::XorGate(){
	setRequiredPorts(3); //out, in1, in2
	setName("XorGate");
}

void XorGate::emulate(DigitalSimulation& c) {
	
	Net* outB = ports[0]->net;
	
	Net* in1B = ports[1]->net;
	Net* in2B = ports[2]->net;
	
	if((in1B->voltage >DIGITAL_LOW && in2B->voltage >DIGITAL_HIGH) || (in1B->voltage >DIGITAL_HIGH && in2B->voltage >DIGITAL_LOW)){
		lastVoltage=DIGITAL_HIGH;
	} else {
		lastVoltage=DIGITAL_LOW;
	}
	
	outB->voltage = lastVoltage;
}
