#include "nand_gate.hpp"

NandGate::NandGate(){
	setRequiredPorts(3); //out, in1, in2
	setName("NandGate");
}

void NandGate::emulate(DigitalSimulation& c) {
	
	Net* outB = ports[0]->net;
	
	Net* in1B = ports[1]->net;
	Net* in2B = ports[2]->net;
	
	if(in1B->voltage >DIGITAL_LOW && in2B->voltage >DIGITAL_LOW){
		lastVoltage=DIGITAL_LOW;
	} else {
		lastVoltage=DIGITAL_HIGH;
	}
	
	outB->voltage = lastVoltage;
}
