#ifndef VIA_HPP
#define VIA_HPP

#include "../electronics/node.hpp"
#include "../abstract/AABB.hpp"
#include <vector>
#include "../../GLOBAL_CONSTANTS.hpp"

struct Via: public Node {
    ImVec2 position;
    double drill_mm;
    double diameter_mm;
	
	AABB bbox;
	
	Via();
	Via(double drill, double diam);
	
	void update(double offX, double offY);
	
	void setPosition(double x, double y);

    void draw(ImDrawList* draw_list, double offX, double offY);
};

#endif