#include "via.hpp"

Via::Via() {
    position = ImVec2(0, 0);
    drill_mm = 40.8f;
    diameter_mm = 50.6f;
}

Via::Via(double drill, double diam){
	drill_mm=drill;
	diameter_mm=diam;
	
	double dist = diameter_mm-drill_mm;
	if(dist<VIA_CLEARANCE_MM){
		drill_mm=0.0;
	}
}
	
void Via::update(double offX, double offY) {
    ImVec2 pos(position.x + offX, position.y + offY);
    double radius = diameter_mm / 2.0f;

    bbox.minX = pos.x - radius;
    bbox.minY = pos.y - radius;
    bbox.maxX = pos.x + radius;
    bbox.maxY = pos.y + radius;
}
	
void Via::setPosition(double x, double y) {
    position.x = x;
    position.y = y;
}

void Via::draw(ImDrawList* draw_list, double offX, double offY) {
    ImVec2 pos(position.x + offX, position.y + offY);

    ImU32 copperColor = COPPER_COLOR;

    draw_list->AddCircle(pos, diameter_mm / 2.0f, copperColor, 32, 1.5f);

	if(drill_mm != 0.0){
		draw_list->AddCircleFilled(pos, drill_mm / 2.0f, CUTOUT_COLOR);
	}

}
