#ifndef TRACE_HPP
#define TRACE_HPP

#include "../electronics/node.hpp"
#include "../abstract/AABB.hpp"
#include <vector>
#include "../../GLOBAL_CONSTANTS.hpp"

struct Trace: public Node {
    double width_mm;
    int layer;              // 0 = top, 1 = bottom
    std::vector<ImVec2> points;
	
	AABB bbox;
	
	Trace();
	Trace(double _width_mm, int _layer);
	
	void update(double offX, double offY);
	
	void setPosition(double x, double y);

    // Draw function
    void draw(ImDrawList* draw_list, double offX, double offY);
};

#endif