#include "trace.hpp"


	
Trace::Trace() {
       width_mm = 0.25;  // default 0.25 mm trace width
       layer = 0;         // default top layer
   }
Trace::Trace(double _width_mm, int _layer) {
       width_mm = _width_mm;  // default 0.25 mm trace width
       layer = _layer;         // default top layer
   }

void Trace::update(double offX, double offY) {
	if (points.empty()) {
		return;
	}

    double _minX = points[0].x + offX;
    double _minY = points[0].y + offY;
    double _maxX = points[0].x + offX;
    double _maxY = points[0].y + offY;

    for (size_t i = 1; i < points.size(); ++i) {
        double x = points[i].x + offX;
        double y = points[i].y + offY;

        if (x < _minX) {
			_minX = x;
		}
			
        if (y < _minY) {
			_minY = y;
		}
			
        if (x > _maxX) {
			_maxX = x;
		}
			
        if (y > _maxY) {
			_maxY = y;
		}
    }

    double halfWidth = width_mm / 2.0;
    bbox.minX = _minX - halfWidth;
    bbox.minY = _minY - halfWidth;
    bbox.maxX = _maxX + halfWidth;
    bbox.maxY = _maxY + halfWidth;
}
	
void Trace::setPosition(double x, double y) {
    if (points.empty()) {
		return;
	}

    ImVec2 currentPos = points[0];
    ImVec2 delta(x - currentPos.x, y - currentPos.y);

    for (auto& p : points) {
        p.x += delta.x;
        p.y += delta.y;
    }
}

    // Draw function
void Trace::draw(ImDrawList* draw_list, double offX, double offY) {
    if (points.size() < 2){
		return;
	}

    ImU32 col = (layer == 1) ? WIRE_COLOR_LAYER2: WIRE_COLOR_LAYER1;

    for (size_t i = 0; i < points.size() - 1; ++i) {
        ImVec2 p0(points[i].x + offX, points[i].y + offY);
        ImVec2 p1(points[i+1].x + offX, points[i+1].y + offY);

        draw_list->AddLine(p0, p1, col, (float)width_mm);
    }
}
