#include "board.hpp"

Board::Board(){
	position =ImVec2(600.0,100.0);
	size =ImVec2(300.0,500.0);
	buffer = ImVec2(0.0,0.0);
	bufferEnd = ImVec2(0.0,0.0);
}

Board::~Board(){
	
}
		
void Board::draw(bool show_overlay_text, ImDrawList* draw_list,double offX, double offY,int cell_size){

	//draw_list->AddRectFilled(ImVec2(position.x + offX, position.y + offY),ImVec2(position.x + size.x+offX, position.y + size.y+offY),PCB_COLOR);

	ImVec2 p0(position.x + offX, position.y + offY);
	ImVec2 p1(position.x + size.x + offX, position.y + size.y + offY);

	draw_list->AddRectFilled(p0, p1, PCB_COLOR);
	double border_thickness = 2.0f; // pixels
	draw_list->AddRect(p0, p1, PCB_BORDER_COLOR, 0.0f, 0, border_thickness);
	
	double Dcell_size = static_cast<double>(cell_size);
	for(double x = 0;x<=size.x;x+=Dcell_size*PCB_ARTIFACT_SCALE){
		for(double y = 0;y<=size.y;y+=Dcell_size*PCB_ARTIFACT_SCALE){
			buffer.x = p0.x+x;
			buffer.y = p0.y+y;
			bufferEnd.x = p0.x+x+PCB_ARTIFACT_SIZE;
			bufferEnd.y = p0.y+y+PCB_ARTIFACT_SIZE;
			
			draw_list->AddRectFilled(buffer, bufferEnd, PCB_ARTIFACT_COLOR);
		}
	}

	for (const Cutout& c : cutouts) {
		if (c.polygon.size() < 3){
			continue;
		}

		std::vector<ImVec2> pts;
		pts.reserve(c.polygon.size());

		for (const ImVec2& v : c.polygon) {
			pts.emplace_back(
				v.x + offX,
				v.y + offY
			);
		}

		draw_list->AddConvexPolyFilled(
			pts.data(),
			pts.size(),
			CUTOUT_COLOR //BG
		);

		draw_list->AddPolyline(
			pts.data(),
			pts.size(),
			PCB_BORDER_COLOR, //OUTLINE
			true,
			1.5f //Cutout strength
		);
	}
	
	for(size_t i =0;i<vias.size();i++){
		vias[i].draw(draw_list,offX,offY);
	}
	
	for(size_t i =0;i<traces.size();i++){
		traces[i].draw(draw_list,offX,offY);
	}
}
		
void Board::update(double oX, double oY){
	for (size_t i = 0; i < cutouts.size(); ++i) {
		cutouts[i].update(oX,oY);
	}
	for (size_t i = 0; i < vias.size(); ++i) {
		vias[i].update(oX,oY);
	}
	for (size_t i = 0; i < traces.size(); ++i) {
		traces[i].update(oX,oY);
	}
}
		
void Board::checkDrag() {
	auto* input = InputState::getInstance();

	if (!input->left_mouse_down){
		return;
	}

	if (!input->dragMode || !input->dragging) {

		for (size_t i = 0; i < cutouts.size(); ++i) {
			if (cutouts[i].bbox.isPointInside(input->mouse_x, input->mouse_y)) {
				input->dragged2DElement = &cutouts[i];
				input->dragging = true;
				return;
			}
		}
		for (size_t i = 0; i < vias.size(); ++i) {
			if (vias[i].bbox.isPointInside(input->mouse_x, input->mouse_y)) {
				input->dragged2DElement = &vias[i];
				input->dragging = true;
				return;
			}
		}
		for (size_t i = 0; i < traces.size(); ++i) {
			if (traces[i].bbox.isPointInside(input->mouse_x, input->mouse_y)) {
				input->dragged2DElement = &traces[i];
				input->dragging = true;
				return;
			}
		}
	}
}

void Board::checkDelete(Node* c){
	
	for(size_t i =0;i<cutouts.size();i++){
		if(&cutouts[i] == c){
			
			cutouts.erase(cutouts.begin() + i);
			return;
		}
	}
	for(size_t i =0;i<vias.size();i++){
		if(&vias[i] == c){
			
			vias.erase(vias.begin() + i);
			return;
		}
	}
	for(size_t i =0;i<traces.size();i++){
		if(&traces[i] == c){
			
			traces.erase(traces.begin() + i);
			return;
		}
	}
}
	